///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1995/2004 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor : Xilinx
// \   \   \/     Version : 8.1i (I.17)
//  \   \         Description : Xilinx Timing Simulation Library Component
//  /   /                  11-Gigabit Transceiver for High-Speed I/O Simulation Model
// /___/   /\     Filename : X_GT11.v
// \   \  /  \    Timestamp : Fri Jun 18 10:57:01 PDT 2004
//  \___\/\___\
//
// Revision:
//    03/23/04 - Initial version.
//    05/16/05 - Changed default values for some parameters and removed two parameters. Fixed CR#207101.
//    08/08/05 - Changed default parameter values for some parameters (CR 214282).
//    02/22/06 - CR#226003 - Added integer, real parameter type
//    02/28/06 - CR#226322 - Addition of new parameters and change of default values for some parameters.
// End Revision

`timescale 1 ps / 1 ps 

module X_GT11 (
	CHBONDO,
	COMBUSOUT,
	DO,
	DRDY,
	RXBUFERR,
	RXCALFAIL,
	RXCHARISCOMMA,
	RXCHARISK,
	RXCOMMADET,
	RXCRCOUT,
	RXCYCLELIMIT,
	RXDATA,
	RXDISPERR,
	RXLOCK,
	RXLOSSOFSYNC,
	RXMCLK,
	RXNOTINTABLE,
	RXPCSHCLKOUT,
	RXREALIGN,
	RXRECCLK1,
	RXRECCLK2,
	RXRUNDISP,
	RXSIGDET,
	RXSTATUS,
	TX1N,
	TX1P,
	TXBUFERR,
	TXCALFAIL,
	TXCRCOUT,
	TXCYCLELIMIT,
	TXKERR,
	TXLOCK,
	TXOUTCLK1,
	TXOUTCLK2,
	TXPCSHCLKOUT,
	TXRUNDISP,
	CHBONDI,
	COMBUSIN,
	DADDR,
	DCLK,
	DEN,
	DI,
	DWE,
	ENCHANSYNC,
	ENMCOMMAALIGN,
	ENPCOMMAALIGN,
	GREFCLK,
	LOOPBACK,
	POWERDOWN,
	REFCLK1,
	REFCLK2,
	RX1N,
	RX1P,
	RXBLOCKSYNC64B66BUSE,
	RXCLKSTABLE,
	RXCOMMADETUSE,
	RXCRCCLK,
	RXCRCDATAVALID,
	RXCRCDATAWIDTH,
	RXCRCIN,
	RXCRCINIT,
	RXCRCINTCLK,
	RXCRCPD,
	RXCRCRESET,
	RXDATAWIDTH,
	RXDEC64B66BUSE,
	RXDEC8B10BUSE,
	RXDESCRAM64B66BUSE,
	RXIGNOREBTF,
	RXINTDATAWIDTH,
	RXPMARESET,
	RXPOLARITY,
	RXRESET,
	RXSLIDE,
	RXSYNC,
	RXUSRCLK,
	RXUSRCLK2,
	TXBYPASS8B10B,
	TXCHARDISPMODE,
	TXCHARDISPVAL,
	TXCHARISK,
	TXCLKSTABLE,
	TXCRCCLK,
	TXCRCDATAVALID,
	TXCRCDATAWIDTH,
	TXCRCIN,
	TXCRCINIT,
	TXCRCINTCLK,
	TXCRCPD,
	TXCRCRESET,
	TXDATA,
	TXDATAWIDTH,
	TXENC64B66BUSE,
	TXENC8B10BUSE,
	TXENOOB,
	TXGEARBOX64B66BUSE,
	TXINHIBIT,
	TXINTDATAWIDTH,
	TXPMARESET,
	TXPOLARITY,
	TXRESET,
	TXSCRAM64B66BUSE,
	TXSYNC,
	TXUSRCLK,
	TXUSRCLK2
);

parameter LOC = "UNPLACED";

parameter BANDGAPSEL = "FALSE";
parameter BIASRESSEL = "FALSE";
parameter CCCB_ARBITRATOR_DISABLE = "FALSE";
parameter CHAN_BOND_MODE = "NONE";
parameter CHAN_BOND_ONE_SHOT = "FALSE";
parameter CHAN_BOND_SEQ_1_1 = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_2 = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_3 = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_4 = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_MASK = 4'b1110;
parameter CHAN_BOND_SEQ_2_1 = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_2 = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_3 = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_4 = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_MASK = 4'b1110;
parameter CHAN_BOND_SEQ_2_USE = "FALSE";
parameter CLK_CORRECT_USE = "FALSE";
parameter CLK_COR_8B10B_DE = "FALSE";
parameter CLK_COR_SEQ_1_1 = 11'b00000000000;
parameter CLK_COR_SEQ_1_2 = 11'b00000000000;
parameter CLK_COR_SEQ_1_3 = 11'b00000000000;
parameter CLK_COR_SEQ_1_4 = 11'b00000000000;
parameter CLK_COR_SEQ_1_MASK = 4'b1110;
parameter CLK_COR_SEQ_2_1 = 11'b00000000000;
parameter CLK_COR_SEQ_2_2 = 11'b00000000000;
parameter CLK_COR_SEQ_2_3 = 11'b00000000000;
parameter CLK_COR_SEQ_2_4 = 11'b00000000000;
parameter CLK_COR_SEQ_2_MASK = 4'b1110;
parameter CLK_COR_SEQ_2_USE = "FALSE";
parameter CLK_COR_SEQ_DROP = "FALSE";
parameter COMMA32 = "FALSE";
parameter COMMA_10B_MASK = 10'h3FF;
parameter CYCLE_LIMIT_SEL = 2'b00;
parameter DCDR_FILTER = 3'b010;
parameter DEC_MCOMMA_DETECT = "TRUE";
parameter DEC_PCOMMA_DETECT = "TRUE";
parameter DEC_VALID_COMMA_ONLY = "TRUE";
parameter DIGRX_FWDCLK = 2'b00;
parameter DIGRX_SYNC_MODE = "FALSE";
parameter ENABLE_DCDR = "FALSE";
parameter FDET_HYS_CAL = 3'b010;
parameter FDET_HYS_SEL = 3'b100;
parameter FDET_LCK_CAL = 3'b100;
parameter FDET_LCK_SEL = 3'b001;
parameter GT11_MODE = "DONT_CARE";
parameter IREFBIASMODE = 2'b11;
parameter LOOPCAL_WAIT = 2'b00;
parameter MCOMMA_32B_VALUE = 32'h00000000;
parameter MCOMMA_DETECT = "TRUE";
parameter OPPOSITE_SELECT = "FALSE";
parameter PCOMMA_32B_VALUE = 32'h00000000;
parameter PCOMMA_DETECT = "TRUE";
parameter PCS_BIT_SLIP = "FALSE";
parameter PMACLKENABLE = "TRUE";
parameter PMACOREPWRENABLE = "TRUE";
parameter PMAIREFTRIM = 4'b0111;
parameter PMAVBGCTRL = 5'b00000;
parameter PMAVREFTRIM = 4'b0111;
parameter PMA_BIT_SLIP = "FALSE";
parameter POWER_ENABLE = "TRUE";
parameter REPEATER = "FALSE";
parameter RXACTST = "FALSE";
parameter RXAFEEQ = 9'b000000000;
parameter RXAFEPD = "FALSE";
parameter RXAFETST = "FALSE";
parameter RXAPD = "FALSE";
parameter RXAREGCTRL = 5'b00000;
parameter RXASYNCDIVIDE = 2'b11;
parameter RXBY_32 = "FALSE";
parameter RXCDRLOS = 6'b000000;
parameter RXCLK0_FORCE_PMACLK = "FALSE";
parameter RXCLKMODE = 6'b110001;
parameter RXCLMODE = 2'b00;
parameter RXCMADJ = 2'b01;
parameter RXCPSEL = "TRUE";
parameter RXCPTST = "FALSE";
parameter RXCRCCLOCKDOUBLE = "FALSE";
parameter RXCRCENABLE = "FALSE";
parameter RXCRCINITVAL = 32'h00000000;
parameter RXCRCINVERTGEN = "FALSE";
parameter RXCRCSAMECLOCK = "FALSE";
parameter RXCTRL1 = 10'h200;
parameter RXCYCLE_LIMIT_SEL = 2'b00;
parameter RXDATA_SEL = 2'b00;
parameter RXDCCOUPLE = "FALSE";
parameter RXDIGRESET = "FALSE";
parameter RXDIGRX = "FALSE";
parameter RXEQ = 64'h4000000000000000;
parameter RXFDCAL_CLOCK_DIVIDE = "NONE";
parameter RXFDET_HYS_CAL = 3'b010;
parameter RXFDET_HYS_SEL = 3'b100;
parameter RXFDET_LCK_CAL = 3'b100;
parameter RXFDET_LCK_SEL = 3'b001;
parameter RXFECONTROL1 = 2'b00;
parameter RXFECONTROL2 = 3'b000;
parameter RXFETUNE = 2'b01;
parameter RXLB = "FALSE";
parameter RXLKADJ = 5'b00000;
parameter RXLKAPD = "FALSE";
parameter RXLOOPCAL_WAIT = 2'b00;
parameter RXLOOPFILT = 4'b0111;
parameter RXMODE = 6'b000000;
parameter RXPD = "FALSE";
parameter RXPDDTST = "TRUE";
parameter RXPMACLKSEL = "REFCLK1";
parameter RXRCPADJ = 3'b011;
parameter RXRCPPD = "FALSE";
parameter RXRECCLK1_USE_SYNC = "FALSE";
parameter RXRIBADJ = 2'b11;
parameter RXRPDPD = "FALSE";
parameter RXRSDPD = "FALSE";
parameter RXSLOWDOWN_CAL = 2'b00;
parameter RXTUNE = 13'h0000;
parameter RXVCODAC_INIT = 10'b1010000000;
parameter RXVCO_CTRL_ENABLE = "FALSE";
parameter RX_BUFFER_USE = "TRUE";
parameter RX_CLOCK_DIVIDER = 2'b00;
parameter SAMPLE_8X = "FALSE";
parameter SLOWDOWN_CAL = 2'b00;
parameter TXABPMACLKSEL = "REFCLK1";
parameter TXAPD = "FALSE";
parameter TXAREFBIASSEL = "TRUE";
parameter TXASYNCDIVIDE = 2'b11;
parameter TXCLK0_FORCE_PMACLK = "FALSE";
parameter TXCLKMODE = 4'b1001;
parameter TXCLMODE = 2'b00;
parameter TXCPSEL = "TRUE";
parameter TXCRCCLOCKDOUBLE = "FALSE";
parameter TXCRCENABLE = "FALSE";
parameter TXCRCINITVAL = 32'h00000000;
parameter TXCRCINVERTGEN = "FALSE";
parameter TXCRCSAMECLOCK = "FALSE";
parameter TXCTRL1 = 10'h200;
parameter TXDATA_SEL = 2'b00;
parameter TXDAT_PRDRV_DAC = 3'b111;
parameter TXDAT_TAP_DAC = 5'b10110;
parameter TXDIGPD = "FALSE";
parameter TXFDCAL_CLOCK_DIVIDE = "NONE";
parameter TXHIGHSIGNALEN = "TRUE";
parameter TXLOOPFILT = 4'b0111;
parameter TXLVLSHFTPD = "FALSE";
parameter TXOUTCLK1_USE_SYNC = "FALSE";
parameter TXPD = "FALSE";
parameter TXPHASESEL = "FALSE";
parameter TXPOST_PRDRV_DAC = 3'b111;
parameter TXPOST_TAP_DAC = 5'b01110;
parameter TXPOST_TAP_PD = "TRUE";
parameter TXPRE_PRDRV_DAC = 3'b111;
parameter TXPRE_TAP_DAC = 5'b00000;
parameter TXPRE_TAP_PD = "TRUE";
parameter TXSLEWRATE = "FALSE";
parameter TXTERMTRIM = 4'b1100;
parameter TXTUNE = 13'h0000;
parameter TX_BUFFER_USE = "TRUE";
parameter TX_CLOCK_DIVIDER = 2'b00;
parameter VCODAC_INIT = 10'b1010000000;
parameter VCO_CTRL_ENABLE = "FALSE";
parameter VREFBIASMODE = 2'b11;
parameter integer ALIGN_COMMA_WORD = 4;
parameter integer CHAN_BOND_LIMIT = 16;
parameter integer CHAN_BOND_SEQ_LEN = 1;
parameter integer CLK_COR_MAX_LAT = 48;
parameter integer CLK_COR_MIN_LAT = 36;
parameter integer CLK_COR_SEQ_LEN = 1;
parameter integer RXOUTDIV2SEL = 1;
parameter integer RXPLLNDIVSEL = 8;
parameter integer RXUSRDIVISOR = 1;
parameter integer SH_CNT_MAX = 64;
parameter integer SH_INVALID_CNT_MAX = 16;
parameter integer TXOUTDIV2SEL = 1;
parameter integer TXPLLNDIVSEL = 8;


output DRDY;
output RXBUFERR;
output RXCALFAIL;
output RXCOMMADET;
output RXCYCLELIMIT;
output RXLOCK;
output RXMCLK;
output RXPCSHCLKOUT;
output RXREALIGN;
output RXRECCLK1;
output RXRECCLK2;
output RXSIGDET;
output TX1N;
output TX1P;
output TXBUFERR;
output TXCALFAIL;
output TXCYCLELIMIT;
output TXLOCK;
output TXOUTCLK1;
output TXOUTCLK2;
output TXPCSHCLKOUT;
output [15:0] COMBUSOUT;
output [15:0] DO;
output [1:0] RXLOSSOFSYNC;
output [31:0] RXCRCOUT;
output [31:0] TXCRCOUT;
output [4:0] CHBONDO;
output [5:0] RXSTATUS;
output [63:0] RXDATA;
output [7:0] RXCHARISCOMMA;
output [7:0] RXCHARISK;
output [7:0] RXDISPERR;
output [7:0] RXNOTINTABLE;
output [7:0] RXRUNDISP;
output [7:0] TXKERR;
output [7:0] TXRUNDISP;

input DCLK;
input DEN;
input DWE;
input ENCHANSYNC;
input ENMCOMMAALIGN;
input ENPCOMMAALIGN;
input GREFCLK;
input POWERDOWN;
input REFCLK1;
input REFCLK2;
input RX1N;
input RX1P;
input RXBLOCKSYNC64B66BUSE;
input RXCLKSTABLE;
input RXCOMMADETUSE;
input RXCRCCLK;
input RXCRCDATAVALID;
input RXCRCINIT;
input RXCRCINTCLK;
input RXCRCPD;
input RXCRCRESET;
input RXDEC64B66BUSE;
input RXDEC8B10BUSE;
input RXDESCRAM64B66BUSE;
input RXIGNOREBTF;
input RXPMARESET;
input RXPOLARITY;
input RXRESET;
input RXSLIDE;
input RXSYNC;
input RXUSRCLK2;
input RXUSRCLK;
input TXCLKSTABLE;
input TXCRCCLK;
input TXCRCDATAVALID;
input TXCRCINIT;
input TXCRCINTCLK;
input TXCRCPD;
input TXCRCRESET;
input TXENC64B66BUSE;
input TXENC8B10BUSE;
input TXENOOB;
input TXGEARBOX64B66BUSE;
input TXINHIBIT;
input TXPMARESET;
input TXPOLARITY;
input TXRESET;
input TXSCRAM64B66BUSE;
input TXSYNC;
input TXUSRCLK2;
input TXUSRCLK;
input [15:0] COMBUSIN;
input [15:0] DI;
input [1:0] LOOPBACK;
input [1:0] RXDATAWIDTH;
input [1:0] RXINTDATAWIDTH;
input [1:0] TXDATAWIDTH;
input [1:0] TXINTDATAWIDTH;
input [2:0] RXCRCDATAWIDTH;
input [2:0] TXCRCDATAWIDTH;
input [4:0] CHBONDI;
input [63:0] RXCRCIN;
input [63:0] TXCRCIN;
input [63:0] TXDATA;
input [7:0] DADDR;
input [7:0] TXBYPASS8B10B;
input [7:0] TXCHARDISPMODE;
input [7:0] TXCHARDISPVAL;
input [7:0] TXCHARISK;

reg BANDGAPSEL_BINARY;
reg BIASRESSEL_BINARY;
reg CCCB_ARBITRATOR_DISABLE_BINARY;
reg CHAN_BOND_ONE_SHOT_BINARY;
reg CHAN_BOND_SEQ_2_USE_BINARY;
reg CLK_CORRECT_USE_BINARY;
reg CLK_COR_8B10B_DE_BINARY;
reg CLK_COR_SEQ_2_USE_BINARY;
reg CLK_COR_SEQ_DROP_BINARY;
reg COMMA32_BINARY;
reg DEC_MCOMMA_DETECT_BINARY;
reg DEC_PCOMMA_DETECT_BINARY;
reg DEC_VALID_COMMA_ONLY_BINARY;
reg DIGRX_SYNC_MODE_BINARY;
reg ENABLE_DCDR_BINARY;
reg MCOMMA_DETECT_BINARY;
reg OPPOSITE_SELECT_BINARY;
reg PCOMMA_DETECT_BINARY;
reg PCS_BIT_SLIP_BINARY;
reg PMACLKENABLE_BINARY;
reg PMACOREPWRENABLE_BINARY;
reg PMA_BIT_SLIP_BINARY;
reg POWER_ENABLE_BINARY;
reg REPEATER_BINARY;
reg RXACTST_BINARY;
reg RXAFEPD_BINARY;
reg RXAFETST_BINARY;
reg RXAPD_BINARY;
reg RXBY_32_BINARY;
reg RXCLK0_FORCE_PMACLK_BINARY;
reg RXCPSEL_BINARY;
reg RXCPTST_BINARY;
reg RXCRCCLOCKDOUBLE_BINARY;
reg RXCRCENABLE_BINARY;
reg RXCRCINVERTGEN_BINARY;
reg RXCRCSAMECLOCK_BINARY;
reg RXDCCOUPLE_BINARY;
reg RXDIGRESET_BINARY;
reg RXDIGRX_BINARY;
reg RXLB_BINARY;
reg RXLKAPD_BINARY;
reg RXPDDTST_BINARY;
reg RXPD_BINARY;
reg RXRCPPD_BINARY;
reg RXRECCLK1_USE_SYNC_BINARY;
reg RXRPDPD_BINARY;
reg RXRSDPD_BINARY;
reg RXVCO_CTRL_ENABLE_BINARY;
reg RX_BUFFER_USE_BINARY;
reg SAMPLE_8X_BINARY;
reg TXAPD_BINARY;
reg TXAREFBIASSEL_BINARY;
reg TXCLK0_FORCE_PMACLK_BINARY;
reg TXCPSEL_BINARY;
reg TXCRCCLOCKDOUBLE_BINARY;
reg TXCRCENABLE_BINARY;
reg TXCRCINVERTGEN_BINARY;
reg TXCRCSAMECLOCK_BINARY;
reg TXDIGPD_BINARY;
reg TXHIGHSIGNALEN_BINARY;
reg TXLVLSHFTPD_BINARY;
reg TXOUTCLK1_USE_SYNC_BINARY;
reg TXPD_BINARY;
reg TXPHASESEL_BINARY;
reg TXPOST_TAP_PD_BINARY;
reg TXPRE_TAP_PD_BINARY;
reg TXSLEWRATE_BINARY;
reg TX_BUFFER_USE_BINARY;
reg VCO_CTRL_ENABLE_BINARY;
reg [1:0] GT11_MODE_BINARY;
reg [12:0] RXTUNE_BINARY;
reg [12:0] TXTUNE_BINARY;
reg [1:0] ALIGN_COMMA_WORD_BINARY;
reg [1:0] CHAN_BOND_MODE_BINARY;
reg [1:0] RXFDCAL_CLOCK_DIVIDE_BINARY;
reg [1:0] RXPMACLKSEL_BINARY;
reg [1:0] TXABPMACLKSEL_BINARY;
reg [1:0] TXFDCAL_CLOCK_DIVIDE_BINARY;
reg [2:0] CHAN_BOND_SEQ_LEN_BINARY;
reg [2:0] CLK_COR_SEQ_LEN_BINARY;
reg [31:0] MCOMMA_32B_VALUE_BINARY;
reg [31:0] PCOMMA_32B_VALUE_BINARY;
reg [31:0] RXCRCINITVAL_BINARY;
reg [31:0] TXCRCINITVAL_BINARY;
reg [3:0] RXPLLNDIVSEL_BINARY;
reg [3:0] TXOUTDIV2SEL_BINARY;
reg [3:0] TXPLLNDIVSEL_BINARY;
reg [4:0] RXUSRDIVISOR_BINARY;
reg [5:0] CHAN_BOND_LIMIT_BINARY;
reg [5:0] CLK_COR_MAX_LAT_BINARY;
reg [5:0] CLK_COR_MIN_LAT_BINARY;
reg [63:0] RXEQ_BINARY;
reg [7:0] RXOUTDIV2SEL_BINARY;
reg [7:0] SH_CNT_MAX_BINARY;
reg [7:0] SH_INVALID_CNT_MAX_BINARY;
reg [9:0] COMMA_10B_MASK_BINARY;
reg [9:0] RXCTRL1_BINARY;
reg [9:0] TXCTRL1_BINARY;

reg notifier;

tri0 GSR = glbl.GSR;

wire DCLK_IN;
wire DEN_IN;
wire DRDY_OUT;
wire DWE_IN;
wire ENCHANSYNC_IN;
wire ENMCOMMAALIGN_IN;
wire ENPCOMMAALIGN_IN;
wire GREFCLK_IN;
wire POWERDOWN_IN;
wire REFCLK1_IN;
wire REFCLK2_IN;
wire RX1N_IN;
wire RX1P_IN;
wire RXBLOCKSYNC64B66BUSE_IN;
wire RXBUFERR_OUT;
wire RXCALFAIL_OUT;
wire RXCLKSTABLE_IN;
wire RXCOMMADETUSE_IN;
wire RXCOMMADET_OUT;
wire RXCRCCLK_IN;
wire RXCRCDATAVALID_IN;
wire RXCRCINIT_IN;
wire RXCRCINTCLK_IN;
wire RXCRCPD_IN;
wire RXCRCRESET_IN;
wire RXCYCLELIMIT_OUT;
wire RXDEC64B66BUSE_IN;
wire RXDEC8B10BUSE_IN;
wire RXDESCRAM64B66BUSE_IN;
wire RXIGNOREBTF_IN;
wire RXLOCK_OUT;
wire RXMCLK_OUT;
wire RXPCSHCLKOUT_OUT;
wire RXPMARESET_IN;
wire RXPOLARITY_IN;
wire RXREALIGN_OUT;
wire RXRECCLK1_OUT;
wire RXRECCLK2_OUT;
wire RXRESET_IN;
wire RXSIGDET_OUT;
wire RXSLIDE_IN;
wire RXSYNC_IN;
wire RXUSRCLK2_IN;
wire RXUSRCLK_IN;
wire TX1N_OUT;
wire TX1P_OUT;
wire TXBUFERR_OUT;
wire TXCALFAIL_OUT;
wire TXCLKSTABLE_IN;
wire TXCRCCLK_IN;
wire TXCRCDATAVALID_IN;
wire TXCRCINIT_IN;
wire TXCRCINTCLK_IN;
wire TXCRCPD_IN;
wire TXCRCRESET_IN;
wire TXCYCLELIMIT_OUT;
wire TXENC64B66BUSE_IN;
wire TXENC8B10BUSE_IN;
wire TXENOOB_IN;
wire TXGEARBOX64B66BUSE_IN;
wire TXINHIBIT_IN;
wire TXLOCK_OUT;
wire TXOUTCLK1_OUT;
wire TXOUTCLK2_OUT;
wire TXPCSHCLKOUT_OUT;
wire TXPMARESET_IN;
wire TXPOLARITY_IN;
wire TXRESET_IN;
wire TXSCRAM64B66BUSE_IN;
wire TXSYNC_IN;
wire TXUSRCLK2_IN;
wire TXUSRCLK_IN;
wire [15:0] COMBUSIN_IN;
wire [15:0] COMBUSOUT_OUT;
wire [15:0] DI_IN;
wire [15:0] DO_OUT;
wire [1:0] LOOPBACK_IN;
wire [1:0] RXDATAWIDTH_IN;
wire [1:0] RXINTDATAWIDTH_IN;
wire [1:0] RXLOSSOFSYNC_OUT;
wire [1:0] TXDATAWIDTH_IN;
wire [1:0] TXINTDATAWIDTH_IN;
wire [2:0] RXCRCDATAWIDTH_IN;
wire [2:0] TXCRCDATAWIDTH_IN;
wire [31:0] RXCRCOUT_OUT;
wire [31:0] TXCRCOUT_OUT;
wire [4:0] CHBONDI_IN;
wire [4:0] CHBONDO_OUT;
wire [5:0] RXSTATUS_OUT;
wire [63:0] RXCRCIN_IN;
wire [63:0] RXDATA_OUT;
wire [63:0] TXCRCIN_IN;
wire [63:0] TXDATA_IN;
wire [7:0] DADDR_IN;
wire [7:0] RXCHARISCOMMA_OUT;
wire [7:0] RXCHARISK_OUT;
wire [7:0] RXDISPERR_OUT;
wire [7:0] RXNOTINTABLE_OUT;
wire [7:0] RXRUNDISP_OUT;
wire [7:0] TXBYPASS8B10B_IN;
wire [7:0] TXCHARDISPMODE_IN;
wire [7:0] TXCHARDISPVAL_IN;
wire [7:0] TXCHARISK_IN;
wire [7:0] TXKERR_OUT;
wire [7:0] TXRUNDISP_OUT;

initial begin
	case (GT11_MODE)
		"B" : GT11_MODE_BINARY <= 2'b00;
		"A" : GT11_MODE_BINARY <= 2'b01;
		"DONT_CARE" : GT11_MODE_BINARY <= 2'b10;
		"SINGLE" : GT11_MODE_BINARY <= 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute GT11_MODE on GT11 instance %m is set to %s.  Legal values for this attribute are DONT_CARE, A, B or SINGLE.", GT11_MODE);
			$finish;
		end
	endcase

	case (CHAN_BOND_LIMIT)
		0 : CHAN_BOND_LIMIT_BINARY <= 6'b000000;
		1 : CHAN_BOND_LIMIT_BINARY <= 6'b000001;
		2 : CHAN_BOND_LIMIT_BINARY <= 6'b000010;
		3 : CHAN_BOND_LIMIT_BINARY <= 6'b000011;
		4 : CHAN_BOND_LIMIT_BINARY <= 6'b000100;
		5 : CHAN_BOND_LIMIT_BINARY <= 6'b000101;
		6 : CHAN_BOND_LIMIT_BINARY <= 6'b000110;
		7 : CHAN_BOND_LIMIT_BINARY <= 6'b000111;
		8 : CHAN_BOND_LIMIT_BINARY <= 6'b001000;
		9 : CHAN_BOND_LIMIT_BINARY <= 6'b001001;
		10 : CHAN_BOND_LIMIT_BINARY <= 6'b001010;
		11 : CHAN_BOND_LIMIT_BINARY <= 6'b001011;
		12 : CHAN_BOND_LIMIT_BINARY <= 6'b001100;
		13 : CHAN_BOND_LIMIT_BINARY <= 6'b001101;
		14 : CHAN_BOND_LIMIT_BINARY <= 6'b001110;
		15 : CHAN_BOND_LIMIT_BINARY <= 6'b001111;
		16 : CHAN_BOND_LIMIT_BINARY <= 6'b010000;
		17 : CHAN_BOND_LIMIT_BINARY <= 6'b010001;
		18 : CHAN_BOND_LIMIT_BINARY <= 6'b010010;
		19 : CHAN_BOND_LIMIT_BINARY <= 6'b010011;
		20 : CHAN_BOND_LIMIT_BINARY <= 6'b010100;
		21 : CHAN_BOND_LIMIT_BINARY <= 6'b010101;
		22 : CHAN_BOND_LIMIT_BINARY <= 6'b010110;
		23 : CHAN_BOND_LIMIT_BINARY <= 6'b010111;
		24 : CHAN_BOND_LIMIT_BINARY <= 6'b011000;
		25 : CHAN_BOND_LIMIT_BINARY <= 6'b011001;
		26 : CHAN_BOND_LIMIT_BINARY <= 6'b011010;
		27 : CHAN_BOND_LIMIT_BINARY <= 6'b011011;
		28 : CHAN_BOND_LIMIT_BINARY <= 6'b011100;
		29 : CHAN_BOND_LIMIT_BINARY <= 6'b011101;
		30 : CHAN_BOND_LIMIT_BINARY <= 6'b011110;
		31 : CHAN_BOND_LIMIT_BINARY <= 6'b011111;
		default : begin
			$display("Attribute Syntax Error : The Attribute CHAN_BOND_LIMIT on X_GT11 instance %m is set to %d.  Legal values for this attribute are 0 to 31.", CHAN_BOND_LIMIT);
			$finish;
		end
	endcase

	case (CHAN_BOND_MODE)
		"NONE" : CHAN_BOND_MODE_BINARY <= 2'b00;
		"MASTER" : CHAN_BOND_MODE_BINARY <= 2'b01;
		"SLAVE_1_HOP" : CHAN_BOND_MODE_BINARY <= 2'b10;
		"SLAVE_2_HOPS" : CHAN_BOND_MODE_BINARY <= 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute CHAN_BOND_MODE on X_GT11 instance %m is set to %s.  Legal values for this attribute are NONE, MASTER, SLAVE_1_HOP or SLAVE_2_HOPS.", CHAN_BOND_MODE);
			$finish;
		end
	endcase

	case (CHAN_BOND_ONE_SHOT)
		"FALSE" : CHAN_BOND_ONE_SHOT_BINARY <= 0;
		"TRUE" : CHAN_BOND_ONE_SHOT_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CHAN_BOND_ONE_SHOT on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CHAN_BOND_ONE_SHOT);
			$finish;
		end
	endcase

	case (CHAN_BOND_SEQ_2_USE)
		"FALSE" : CHAN_BOND_SEQ_2_USE_BINARY <= 0;
		"TRUE" : CHAN_BOND_SEQ_2_USE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CHAN_BOND_SEQ_2_USE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CHAN_BOND_SEQ_2_USE);
			$finish;
		end
	endcase

	case (CHAN_BOND_SEQ_LEN)
		1 : CHAN_BOND_SEQ_LEN_BINARY <= 3'b000;
		2 : CHAN_BOND_SEQ_LEN_BINARY <= 3'b001;
		3 : CHAN_BOND_SEQ_LEN_BINARY <= 3'b010;
		4 : CHAN_BOND_SEQ_LEN_BINARY <= 3'b011;
		8 : CHAN_BOND_SEQ_LEN_BINARY <= 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute CHAN_BOND_SEQ_LEN on X_GT11 instance %m is set to %d.  Legal values for this attribute are 1, 2, 3, 4 or 8.", CHAN_BOND_SEQ_LEN);
			$finish;
		end
	endcase

	case (RX_BUFFER_USE)
		"FALSE" : RX_BUFFER_USE_BINARY <= 0;
		"TRUE" : RX_BUFFER_USE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RX_BUFFER_USE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RX_BUFFER_USE);
			$finish;
		end
	endcase

	case (TX_BUFFER_USE)
		"FALSE" : TX_BUFFER_USE_BINARY <= 0;
		"TRUE" : TX_BUFFER_USE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TX_BUFFER_USE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TX_BUFFER_USE);
			$finish;
		end
	endcase

	case (POWER_ENABLE)
		"FALSE" : POWER_ENABLE_BINARY <= 0;
		"TRUE" : POWER_ENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute POWER_ENABLE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", POWER_ENABLE);
			$finish;
		end
	endcase

	case (OPPOSITE_SELECT)
		"FALSE" : OPPOSITE_SELECT_BINARY <= 0;
		"TRUE" : OPPOSITE_SELECT_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute OPPOSITE_SELECT on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", OPPOSITE_SELECT);
			$finish;
		end
	endcase

	case (CCCB_ARBITRATOR_DISABLE)
		"FALSE" : CCCB_ARBITRATOR_DISABLE_BINARY <= 0;
		"TRUE" : CCCB_ARBITRATOR_DISABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CCCB_ARBITRATOR_DISABLE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CCCB_ARBITRATOR_DISABLE);
			$finish;
		end
	endcase

	case (DIGRX_SYNC_MODE)
		"FALSE" : DIGRX_SYNC_MODE_BINARY <= 0;
		"TRUE" : DIGRX_SYNC_MODE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DIGRX_SYNC_MODE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DIGRX_SYNC_MODE);
			$finish;
		end
	endcase

	case (PCS_BIT_SLIP)
		"FALSE" : PCS_BIT_SLIP_BINARY <= 0;
		"TRUE" : PCS_BIT_SLIP_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PCS_BIT_SLIP on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PCS_BIT_SLIP);
			$finish;
		end
	endcase

	case (CLK_COR_MIN_LAT)
		0 : CLK_COR_MIN_LAT_BINARY <= 6'b000000;
		1 : CLK_COR_MIN_LAT_BINARY <= 6'b000001;
		2 : CLK_COR_MIN_LAT_BINARY <= 6'b000010;
		3 : CLK_COR_MIN_LAT_BINARY <= 6'b000011;
		4 : CLK_COR_MIN_LAT_BINARY <= 6'b000100;
		5 : CLK_COR_MIN_LAT_BINARY <= 6'b000101;
		6 : CLK_COR_MIN_LAT_BINARY <= 6'b000110;
		7 : CLK_COR_MIN_LAT_BINARY <= 6'b000111;
		8 : CLK_COR_MIN_LAT_BINARY <= 6'b001000;
		9 : CLK_COR_MIN_LAT_BINARY <= 6'b001001;
		10 : CLK_COR_MIN_LAT_BINARY <= 6'b001010;
		11 : CLK_COR_MIN_LAT_BINARY <= 6'b001011;
		12 : CLK_COR_MIN_LAT_BINARY <= 6'b001100;
		13 : CLK_COR_MIN_LAT_BINARY <= 6'b001101;
		14 : CLK_COR_MIN_LAT_BINARY <= 6'b001110;
		15 : CLK_COR_MIN_LAT_BINARY <= 6'b001111;
		16 : CLK_COR_MIN_LAT_BINARY <= 6'b010000;
		17 : CLK_COR_MIN_LAT_BINARY <= 6'b010001;
		18 : CLK_COR_MIN_LAT_BINARY <= 6'b010010;
		19 : CLK_COR_MIN_LAT_BINARY <= 6'b010011;
		20 : CLK_COR_MIN_LAT_BINARY <= 6'b010100;
		21 : CLK_COR_MIN_LAT_BINARY <= 6'b010101;
		22 : CLK_COR_MIN_LAT_BINARY <= 6'b010110;
		23 : CLK_COR_MIN_LAT_BINARY <= 6'b010111;
		24 : CLK_COR_MIN_LAT_BINARY <= 6'b011000;
		25 : CLK_COR_MIN_LAT_BINARY <= 6'b011001;
		26 : CLK_COR_MIN_LAT_BINARY <= 6'b011010;
		27 : CLK_COR_MIN_LAT_BINARY <= 6'b011011;
		28 : CLK_COR_MIN_LAT_BINARY <= 6'b011100;
		29 : CLK_COR_MIN_LAT_BINARY <= 6'b011101;
		30 : CLK_COR_MIN_LAT_BINARY <= 6'b011110;
		31 : CLK_COR_MIN_LAT_BINARY <= 6'b011111;
		32 : CLK_COR_MIN_LAT_BINARY <= 6'b100000;
		33 : CLK_COR_MIN_LAT_BINARY <= 6'b100001;
		34 : CLK_COR_MIN_LAT_BINARY <= 6'b100010;
		35 : CLK_COR_MIN_LAT_BINARY <= 6'b100011;
		36 : CLK_COR_MIN_LAT_BINARY <= 6'b100100;
		37 : CLK_COR_MIN_LAT_BINARY <= 6'b100101;
		38 : CLK_COR_MIN_LAT_BINARY <= 6'b100110;
		39 : CLK_COR_MIN_LAT_BINARY <= 6'b100111;
		40 : CLK_COR_MIN_LAT_BINARY <= 6'b101000;
		41 : CLK_COR_MIN_LAT_BINARY <= 6'b101001;
		42 : CLK_COR_MIN_LAT_BINARY <= 6'b101010;
		43 : CLK_COR_MIN_LAT_BINARY <= 6'b101011;
		44 : CLK_COR_MIN_LAT_BINARY <= 6'b101100;
		45 : CLK_COR_MIN_LAT_BINARY <= 6'b101101;
		46 : CLK_COR_MIN_LAT_BINARY <= 6'b101110;
		47 : CLK_COR_MIN_LAT_BINARY <= 6'b101111;
		48 : CLK_COR_MIN_LAT_BINARY <= 6'b110000;
		49 : CLK_COR_MIN_LAT_BINARY <= 6'b110001;
		50 : CLK_COR_MIN_LAT_BINARY <= 6'b110010;
		51 : CLK_COR_MIN_LAT_BINARY <= 6'b110011;
		52 : CLK_COR_MIN_LAT_BINARY <= 6'b110100;
		53 : CLK_COR_MIN_LAT_BINARY <= 6'b110101;
		54 : CLK_COR_MIN_LAT_BINARY <= 6'b110110;
		55 : CLK_COR_MIN_LAT_BINARY <= 6'b110111;
		56 : CLK_COR_MIN_LAT_BINARY <= 6'b111000;
		57 : CLK_COR_MIN_LAT_BINARY <= 6'b111001;
		58 : CLK_COR_MIN_LAT_BINARY <= 6'b111010;
		59 : CLK_COR_MIN_LAT_BINARY <= 6'b111011;
		60 : CLK_COR_MIN_LAT_BINARY <= 6'b111100;
		61 : CLK_COR_MIN_LAT_BINARY <= 6'b111101;
		62 : CLK_COR_MIN_LAT_BINARY <= 6'b111110;
		63 : CLK_COR_MIN_LAT_BINARY <= 6'b111111;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_COR_MIN_LAT on X_GT11 instance %m is set to %d.  Legal values for this attribute are 0 to 63.", CLK_COR_MIN_LAT);
			$finish;
		end
	endcase

	case (CLK_COR_MAX_LAT)
		0 : CLK_COR_MAX_LAT_BINARY <= 6'b000000;
		1 : CLK_COR_MAX_LAT_BINARY <= 6'b000001;
		2 : CLK_COR_MAX_LAT_BINARY <= 6'b000010;
		3 : CLK_COR_MAX_LAT_BINARY <= 6'b000011;
		4 : CLK_COR_MAX_LAT_BINARY <= 6'b000100;
		5 : CLK_COR_MAX_LAT_BINARY <= 6'b000101;
		6 : CLK_COR_MAX_LAT_BINARY <= 6'b000110;
		7 : CLK_COR_MAX_LAT_BINARY <= 6'b000111;
		8 : CLK_COR_MAX_LAT_BINARY <= 6'b001000;
		9 : CLK_COR_MAX_LAT_BINARY <= 6'b001001;
		10 : CLK_COR_MAX_LAT_BINARY <= 6'b001010;
		11 : CLK_COR_MAX_LAT_BINARY <= 6'b001011;
		12 : CLK_COR_MAX_LAT_BINARY <= 6'b001100;
		13 : CLK_COR_MAX_LAT_BINARY <= 6'b001101;
		14 : CLK_COR_MAX_LAT_BINARY <= 6'b001110;
		15 : CLK_COR_MAX_LAT_BINARY <= 6'b001111;
		16 : CLK_COR_MAX_LAT_BINARY <= 6'b010000;
		17 : CLK_COR_MAX_LAT_BINARY <= 6'b010001;
		18 : CLK_COR_MAX_LAT_BINARY <= 6'b010010;
		19 : CLK_COR_MAX_LAT_BINARY <= 6'b010011;
		20 : CLK_COR_MAX_LAT_BINARY <= 6'b010100;
		21 : CLK_COR_MAX_LAT_BINARY <= 6'b010101;
		22 : CLK_COR_MAX_LAT_BINARY <= 6'b010110;
		23 : CLK_COR_MAX_LAT_BINARY <= 6'b010111;
		24 : CLK_COR_MAX_LAT_BINARY <= 6'b011000;
		25 : CLK_COR_MAX_LAT_BINARY <= 6'b011001;
		26 : CLK_COR_MAX_LAT_BINARY <= 6'b011010;
		27 : CLK_COR_MAX_LAT_BINARY <= 6'b011011;
		28 : CLK_COR_MAX_LAT_BINARY <= 6'b011100;
		29 : CLK_COR_MAX_LAT_BINARY <= 6'b011101;
		30 : CLK_COR_MAX_LAT_BINARY <= 6'b011110;
		31 : CLK_COR_MAX_LAT_BINARY <= 6'b011111;
		32 : CLK_COR_MAX_LAT_BINARY <= 6'b100000;
		33 : CLK_COR_MAX_LAT_BINARY <= 6'b100001;
		34 : CLK_COR_MAX_LAT_BINARY <= 6'b100010;
		35 : CLK_COR_MAX_LAT_BINARY <= 6'b100011;
		36 : CLK_COR_MAX_LAT_BINARY <= 6'b100100;
		37 : CLK_COR_MAX_LAT_BINARY <= 6'b100101;
		38 : CLK_COR_MAX_LAT_BINARY <= 6'b100110;
		39 : CLK_COR_MAX_LAT_BINARY <= 6'b100111;
		40 : CLK_COR_MAX_LAT_BINARY <= 6'b101000;
		41 : CLK_COR_MAX_LAT_BINARY <= 6'b101001;
		42 : CLK_COR_MAX_LAT_BINARY <= 6'b101010;
		43 : CLK_COR_MAX_LAT_BINARY <= 6'b101011;
		44 : CLK_COR_MAX_LAT_BINARY <= 6'b101100;
		45 : CLK_COR_MAX_LAT_BINARY <= 6'b101101;
		46 : CLK_COR_MAX_LAT_BINARY <= 6'b101110;
		47 : CLK_COR_MAX_LAT_BINARY <= 6'b101111;
		48 : CLK_COR_MAX_LAT_BINARY <= 6'b110000;
		49 : CLK_COR_MAX_LAT_BINARY <= 6'b110001;
		50 : CLK_COR_MAX_LAT_BINARY <= 6'b110010;
		51 : CLK_COR_MAX_LAT_BINARY <= 6'b110011;
		52 : CLK_COR_MAX_LAT_BINARY <= 6'b110100;
		53 : CLK_COR_MAX_LAT_BINARY <= 6'b110101;
		54 : CLK_COR_MAX_LAT_BINARY <= 6'b110110;
		55 : CLK_COR_MAX_LAT_BINARY <= 6'b110111;
		56 : CLK_COR_MAX_LAT_BINARY <= 6'b111000;
		57 : CLK_COR_MAX_LAT_BINARY <= 6'b111001;
		58 : CLK_COR_MAX_LAT_BINARY <= 6'b111010;
		59 : CLK_COR_MAX_LAT_BINARY <= 6'b111011;
		60 : CLK_COR_MAX_LAT_BINARY <= 6'b111100;
		61 : CLK_COR_MAX_LAT_BINARY <= 6'b111101;
		62 : CLK_COR_MAX_LAT_BINARY <= 6'b111110;
		63 : CLK_COR_MAX_LAT_BINARY <= 6'b111111;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_COR_MAX_LAT on X_GT11 instance %m is set to %d.  Legal values for this attribute are 0 to 63.", CLK_COR_MAX_LAT);
			$finish;
		end
	endcase

	case (CLK_COR_SEQ_2_USE)
		"FALSE" : CLK_COR_SEQ_2_USE_BINARY <= 0;
		"TRUE" : CLK_COR_SEQ_2_USE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_COR_SEQ_2_USE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CLK_COR_SEQ_2_USE);
			$finish;
		end
	endcase

	case (CLK_COR_SEQ_DROP)
		"FALSE" : CLK_COR_SEQ_DROP_BINARY <= 0;
		"TRUE" : CLK_COR_SEQ_DROP_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_COR_SEQ_DROP on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CLK_COR_SEQ_DROP);
			$finish;
		end
	endcase

	case (CLK_COR_SEQ_LEN)
		1 : CLK_COR_SEQ_LEN_BINARY <= 3'b000;
		2 : CLK_COR_SEQ_LEN_BINARY <= 3'b001;
		3 : CLK_COR_SEQ_LEN_BINARY <= 3'b010;
		4 : CLK_COR_SEQ_LEN_BINARY <= 3'b011;
		8 : CLK_COR_SEQ_LEN_BINARY <= 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_COR_SEQ_LEN on X_GT11 instance %m is set to %d.  Legal values for this attribute are 1, 2, 3, 4 or 8.", CLK_COR_SEQ_LEN);
			$finish;
		end
	endcase

	case (CLK_CORRECT_USE)
		"FALSE" : CLK_CORRECT_USE_BINARY <= 0;
		"TRUE" : CLK_CORRECT_USE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_CORRECT_USE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CLK_CORRECT_USE);
			$finish;
		end
	endcase

	case (CLK_COR_8B10B_DE)
		"FALSE" : CLK_COR_8B10B_DE_BINARY <= 0;
		"TRUE" : CLK_COR_8B10B_DE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_COR_8B10B_DE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CLK_COR_8B10B_DE);
			$finish;
		end
	endcase

	case (SH_CNT_MAX)
		0 : SH_CNT_MAX_BINARY <= 8'b00000000;
		1 : SH_CNT_MAX_BINARY <= 8'b00000001;
		2 : SH_CNT_MAX_BINARY <= 8'b00000010;
		3 : SH_CNT_MAX_BINARY <= 8'b00000011;
		4 : SH_CNT_MAX_BINARY <= 8'b00000100;
		5 : SH_CNT_MAX_BINARY <= 8'b00000101;
		6 : SH_CNT_MAX_BINARY <= 8'b00000110;
		7 : SH_CNT_MAX_BINARY <= 8'b00000111;
		8 : SH_CNT_MAX_BINARY <= 8'b00001000;
		9 : SH_CNT_MAX_BINARY <= 8'b00001001;
		10 : SH_CNT_MAX_BINARY <= 8'b00001010;
		11 : SH_CNT_MAX_BINARY <= 8'b00001011;
		12 : SH_CNT_MAX_BINARY <= 8'b00001100;
		13 : SH_CNT_MAX_BINARY <= 8'b00001101;
		14 : SH_CNT_MAX_BINARY <= 8'b00001110;
		15 : SH_CNT_MAX_BINARY <= 8'b00001111;
		16 : SH_CNT_MAX_BINARY <= 8'b00010000;
		17 : SH_CNT_MAX_BINARY <= 8'b00010001;
		18 : SH_CNT_MAX_BINARY <= 8'b00010010;
		19 : SH_CNT_MAX_BINARY <= 8'b00010011;
		20 : SH_CNT_MAX_BINARY <= 8'b00010100;
		21 : SH_CNT_MAX_BINARY <= 8'b00010101;
		22 : SH_CNT_MAX_BINARY <= 8'b00010110;
		23 : SH_CNT_MAX_BINARY <= 8'b00010111;
		24 : SH_CNT_MAX_BINARY <= 8'b00011000;
		25 : SH_CNT_MAX_BINARY <= 8'b00011001;
		26 : SH_CNT_MAX_BINARY <= 8'b00011010;
		27 : SH_CNT_MAX_BINARY <= 8'b00011011;
		28 : SH_CNT_MAX_BINARY <= 8'b00011100;
		29 : SH_CNT_MAX_BINARY <= 8'b00011101;
		30 : SH_CNT_MAX_BINARY <= 8'b00011110;
		31 : SH_CNT_MAX_BINARY <= 8'b00011111;
		32 : SH_CNT_MAX_BINARY <= 8'b00100000;
		33 : SH_CNT_MAX_BINARY <= 8'b00100001;
		34 : SH_CNT_MAX_BINARY <= 8'b00100010;
		35 : SH_CNT_MAX_BINARY <= 8'b00100011;
		36 : SH_CNT_MAX_BINARY <= 8'b00100100;
		37 : SH_CNT_MAX_BINARY <= 8'b00100101;
		38 : SH_CNT_MAX_BINARY <= 8'b00100110;
		39 : SH_CNT_MAX_BINARY <= 8'b00100111;
		40 : SH_CNT_MAX_BINARY <= 8'b00101000;
		41 : SH_CNT_MAX_BINARY <= 8'b00101001;
		42 : SH_CNT_MAX_BINARY <= 8'b00101010;
		43 : SH_CNT_MAX_BINARY <= 8'b00101011;
		44 : SH_CNT_MAX_BINARY <= 8'b00101100;
		45 : SH_CNT_MAX_BINARY <= 8'b00101101;
		46 : SH_CNT_MAX_BINARY <= 8'b00101110;
		47 : SH_CNT_MAX_BINARY <= 8'b00101111;
		48 : SH_CNT_MAX_BINARY <= 8'b00110000;
		49 : SH_CNT_MAX_BINARY <= 8'b00110001;
		50 : SH_CNT_MAX_BINARY <= 8'b00110010;
		51 : SH_CNT_MAX_BINARY <= 8'b00110011;
		52 : SH_CNT_MAX_BINARY <= 8'b00110100;
		53 : SH_CNT_MAX_BINARY <= 8'b00110101;
		54 : SH_CNT_MAX_BINARY <= 8'b00110110;
		55 : SH_CNT_MAX_BINARY <= 8'b00110111;
		56 : SH_CNT_MAX_BINARY <= 8'b00111000;
		57 : SH_CNT_MAX_BINARY <= 8'b00111001;
		58 : SH_CNT_MAX_BINARY <= 8'b00111010;
		59 : SH_CNT_MAX_BINARY <= 8'b00111011;
		60 : SH_CNT_MAX_BINARY <= 8'b00111100;
		61 : SH_CNT_MAX_BINARY <= 8'b00111101;
		62 : SH_CNT_MAX_BINARY <= 8'b00111110;
		63 : SH_CNT_MAX_BINARY <= 8'b00111111;
		64 : SH_CNT_MAX_BINARY <= 8'b01000000;
		65 : SH_CNT_MAX_BINARY <= 8'b01000001;
		66 : SH_CNT_MAX_BINARY <= 8'b01000010;
		67 : SH_CNT_MAX_BINARY <= 8'b01000011;
		68 : SH_CNT_MAX_BINARY <= 8'b01000100;
		69 : SH_CNT_MAX_BINARY <= 8'b01000101;
		70 : SH_CNT_MAX_BINARY <= 8'b01000110;
		71 : SH_CNT_MAX_BINARY <= 8'b01000111;
		72 : SH_CNT_MAX_BINARY <= 8'b01001000;
		73 : SH_CNT_MAX_BINARY <= 8'b01001001;
		74 : SH_CNT_MAX_BINARY <= 8'b01001010;
		75 : SH_CNT_MAX_BINARY <= 8'b01001011;
		76 : SH_CNT_MAX_BINARY <= 8'b01001100;
		77 : SH_CNT_MAX_BINARY <= 8'b01001101;
		78 : SH_CNT_MAX_BINARY <= 8'b01001110;
		79 : SH_CNT_MAX_BINARY <= 8'b01001111;
		80 : SH_CNT_MAX_BINARY <= 8'b01010000;
		81 : SH_CNT_MAX_BINARY <= 8'b01010001;
		82 : SH_CNT_MAX_BINARY <= 8'b01010010;
		83 : SH_CNT_MAX_BINARY <= 8'b01010011;
		84 : SH_CNT_MAX_BINARY <= 8'b01010100;
		85 : SH_CNT_MAX_BINARY <= 8'b01010101;
		86 : SH_CNT_MAX_BINARY <= 8'b01010110;
		87 : SH_CNT_MAX_BINARY <= 8'b01010111;
		88 : SH_CNT_MAX_BINARY <= 8'b01011000;
		89 : SH_CNT_MAX_BINARY <= 8'b01011001;
		90 : SH_CNT_MAX_BINARY <= 8'b01011010;
		91 : SH_CNT_MAX_BINARY <= 8'b01011011;
		92 : SH_CNT_MAX_BINARY <= 8'b01011100;
		93 : SH_CNT_MAX_BINARY <= 8'b01011101;
		94 : SH_CNT_MAX_BINARY <= 8'b01011110;
		95 : SH_CNT_MAX_BINARY <= 8'b01011111;
		96 : SH_CNT_MAX_BINARY <= 8'b01100000;
		97 : SH_CNT_MAX_BINARY <= 8'b01100001;
		98 : SH_CNT_MAX_BINARY <= 8'b01100010;
		99 : SH_CNT_MAX_BINARY <= 8'b01100011;
		100 : SH_CNT_MAX_BINARY <= 8'b01100100;
		101 : SH_CNT_MAX_BINARY <= 8'b01100101;
		102 : SH_CNT_MAX_BINARY <= 8'b01100110;
		103 : SH_CNT_MAX_BINARY <= 8'b01100111;
		104 : SH_CNT_MAX_BINARY <= 8'b01101000;
		105 : SH_CNT_MAX_BINARY <= 8'b01101001;
		106 : SH_CNT_MAX_BINARY <= 8'b01101010;
		107 : SH_CNT_MAX_BINARY <= 8'b01101011;
		108 : SH_CNT_MAX_BINARY <= 8'b01101100;
		109 : SH_CNT_MAX_BINARY <= 8'b01101101;
		110 : SH_CNT_MAX_BINARY <= 8'b01101110;
		111 : SH_CNT_MAX_BINARY <= 8'b01101111;
		112 : SH_CNT_MAX_BINARY <= 8'b01110000;
		113 : SH_CNT_MAX_BINARY <= 8'b01110001;
		114 : SH_CNT_MAX_BINARY <= 8'b01110010;
		115 : SH_CNT_MAX_BINARY <= 8'b01110011;
		116 : SH_CNT_MAX_BINARY <= 8'b01110100;
		117 : SH_CNT_MAX_BINARY <= 8'b01110101;
		118 : SH_CNT_MAX_BINARY <= 8'b01110110;
		119 : SH_CNT_MAX_BINARY <= 8'b01110111;
		120 : SH_CNT_MAX_BINARY <= 8'b01111000;
		121 : SH_CNT_MAX_BINARY <= 8'b01111001;
		122 : SH_CNT_MAX_BINARY <= 8'b01111010;
		123 : SH_CNT_MAX_BINARY <= 8'b01111011;
		124 : SH_CNT_MAX_BINARY <= 8'b01111100;
		125 : SH_CNT_MAX_BINARY <= 8'b01111101;
		126 : SH_CNT_MAX_BINARY <= 8'b01111110;
		127 : SH_CNT_MAX_BINARY <= 8'b01111111;
		128 : SH_CNT_MAX_BINARY <= 8'b10000000;
		129 : SH_CNT_MAX_BINARY <= 8'b10000001;
		130 : SH_CNT_MAX_BINARY <= 8'b10000010;
		131 : SH_CNT_MAX_BINARY <= 8'b10000011;
		132 : SH_CNT_MAX_BINARY <= 8'b10000100;
		133 : SH_CNT_MAX_BINARY <= 8'b10000101;
		134 : SH_CNT_MAX_BINARY <= 8'b10000110;
		135 : SH_CNT_MAX_BINARY <= 8'b10000111;
		136 : SH_CNT_MAX_BINARY <= 8'b10001000;
		137 : SH_CNT_MAX_BINARY <= 8'b10001001;
		138 : SH_CNT_MAX_BINARY <= 8'b10001010;
		139 : SH_CNT_MAX_BINARY <= 8'b10001011;
		140 : SH_CNT_MAX_BINARY <= 8'b10001100;
		141 : SH_CNT_MAX_BINARY <= 8'b10001101;
		142 : SH_CNT_MAX_BINARY <= 8'b10001110;
		143 : SH_CNT_MAX_BINARY <= 8'b10001111;
		144 : SH_CNT_MAX_BINARY <= 8'b10010000;
		145 : SH_CNT_MAX_BINARY <= 8'b10010001;
		146 : SH_CNT_MAX_BINARY <= 8'b10010010;
		147 : SH_CNT_MAX_BINARY <= 8'b10010011;
		148 : SH_CNT_MAX_BINARY <= 8'b10010100;
		149 : SH_CNT_MAX_BINARY <= 8'b10010101;
		150 : SH_CNT_MAX_BINARY <= 8'b10010110;
		151 : SH_CNT_MAX_BINARY <= 8'b10010111;
		152 : SH_CNT_MAX_BINARY <= 8'b10011000;
		153 : SH_CNT_MAX_BINARY <= 8'b10011001;
		154 : SH_CNT_MAX_BINARY <= 8'b10011010;
		155 : SH_CNT_MAX_BINARY <= 8'b10011011;
		156 : SH_CNT_MAX_BINARY <= 8'b10011100;
		157 : SH_CNT_MAX_BINARY <= 8'b10011101;
		158 : SH_CNT_MAX_BINARY <= 8'b10011110;
		159 : SH_CNT_MAX_BINARY <= 8'b10011111;
		160 : SH_CNT_MAX_BINARY <= 8'b10100000;
		161 : SH_CNT_MAX_BINARY <= 8'b10100001;
		162 : SH_CNT_MAX_BINARY <= 8'b10100010;
		163 : SH_CNT_MAX_BINARY <= 8'b10100011;
		164 : SH_CNT_MAX_BINARY <= 8'b10100100;
		165 : SH_CNT_MAX_BINARY <= 8'b10100101;
		166 : SH_CNT_MAX_BINARY <= 8'b10100110;
		167 : SH_CNT_MAX_BINARY <= 8'b10100111;
		168 : SH_CNT_MAX_BINARY <= 8'b10101000;
		169 : SH_CNT_MAX_BINARY <= 8'b10101001;
		170 : SH_CNT_MAX_BINARY <= 8'b10101010;
		171 : SH_CNT_MAX_BINARY <= 8'b10101011;
		172 : SH_CNT_MAX_BINARY <= 8'b10101100;
		173 : SH_CNT_MAX_BINARY <= 8'b10101101;
		174 : SH_CNT_MAX_BINARY <= 8'b10101110;
		175 : SH_CNT_MAX_BINARY <= 8'b10101111;
		176 : SH_CNT_MAX_BINARY <= 8'b10110000;
		177 : SH_CNT_MAX_BINARY <= 8'b10110001;
		178 : SH_CNT_MAX_BINARY <= 8'b10110010;
		179 : SH_CNT_MAX_BINARY <= 8'b10110011;
		180 : SH_CNT_MAX_BINARY <= 8'b10110100;
		181 : SH_CNT_MAX_BINARY <= 8'b10110101;
		182 : SH_CNT_MAX_BINARY <= 8'b10110110;
		183 : SH_CNT_MAX_BINARY <= 8'b10110111;
		184 : SH_CNT_MAX_BINARY <= 8'b10111000;
		185 : SH_CNT_MAX_BINARY <= 8'b10111001;
		186 : SH_CNT_MAX_BINARY <= 8'b10111010;
		187 : SH_CNT_MAX_BINARY <= 8'b10111011;
		188 : SH_CNT_MAX_BINARY <= 8'b10111100;
		189 : SH_CNT_MAX_BINARY <= 8'b10111101;
		190 : SH_CNT_MAX_BINARY <= 8'b10111110;
		191 : SH_CNT_MAX_BINARY <= 8'b10111111;
		192 : SH_CNT_MAX_BINARY <= 8'b11000000;
		193 : SH_CNT_MAX_BINARY <= 8'b11000001;
		194 : SH_CNT_MAX_BINARY <= 8'b11000010;
		195 : SH_CNT_MAX_BINARY <= 8'b11000011;
		196 : SH_CNT_MAX_BINARY <= 8'b11000100;
		197 : SH_CNT_MAX_BINARY <= 8'b11000101;
		198 : SH_CNT_MAX_BINARY <= 8'b11000110;
		199 : SH_CNT_MAX_BINARY <= 8'b11000111;
		200 : SH_CNT_MAX_BINARY <= 8'b11001000;
		201 : SH_CNT_MAX_BINARY <= 8'b11001001;
		202 : SH_CNT_MAX_BINARY <= 8'b11001010;
		203 : SH_CNT_MAX_BINARY <= 8'b11001011;
		204 : SH_CNT_MAX_BINARY <= 8'b11001100;
		205 : SH_CNT_MAX_BINARY <= 8'b11001101;
		206 : SH_CNT_MAX_BINARY <= 8'b11001110;
		207 : SH_CNT_MAX_BINARY <= 8'b11001111;
		208 : SH_CNT_MAX_BINARY <= 8'b11010000;
		209 : SH_CNT_MAX_BINARY <= 8'b11010001;
		210 : SH_CNT_MAX_BINARY <= 8'b11010010;
		211 : SH_CNT_MAX_BINARY <= 8'b11010011;
		212 : SH_CNT_MAX_BINARY <= 8'b11010100;
		213 : SH_CNT_MAX_BINARY <= 8'b11010101;
		214 : SH_CNT_MAX_BINARY <= 8'b11010110;
		215 : SH_CNT_MAX_BINARY <= 8'b11010111;
		216 : SH_CNT_MAX_BINARY <= 8'b11011000;
		217 : SH_CNT_MAX_BINARY <= 8'b11011001;
		218 : SH_CNT_MAX_BINARY <= 8'b11011010;
		219 : SH_CNT_MAX_BINARY <= 8'b11011011;
		220 : SH_CNT_MAX_BINARY <= 8'b11011100;
		221 : SH_CNT_MAX_BINARY <= 8'b11011101;
		222 : SH_CNT_MAX_BINARY <= 8'b11011110;
		223 : SH_CNT_MAX_BINARY <= 8'b11011111;
		224 : SH_CNT_MAX_BINARY <= 8'b11100000;
		225 : SH_CNT_MAX_BINARY <= 8'b11100001;
		226 : SH_CNT_MAX_BINARY <= 8'b11100010;
		227 : SH_CNT_MAX_BINARY <= 8'b11100011;
		228 : SH_CNT_MAX_BINARY <= 8'b11100100;
		229 : SH_CNT_MAX_BINARY <= 8'b11100101;
		230 : SH_CNT_MAX_BINARY <= 8'b11100110;
		231 : SH_CNT_MAX_BINARY <= 8'b11100111;
		232 : SH_CNT_MAX_BINARY <= 8'b11101000;
		233 : SH_CNT_MAX_BINARY <= 8'b11101001;
		234 : SH_CNT_MAX_BINARY <= 8'b11101010;
		235 : SH_CNT_MAX_BINARY <= 8'b11101011;
		236 : SH_CNT_MAX_BINARY <= 8'b11101100;
		237 : SH_CNT_MAX_BINARY <= 8'b11101101;
		238 : SH_CNT_MAX_BINARY <= 8'b11101110;
		239 : SH_CNT_MAX_BINARY <= 8'b11101111;
		240 : SH_CNT_MAX_BINARY <= 8'b11110000;
		241 : SH_CNT_MAX_BINARY <= 8'b11110001;
		242 : SH_CNT_MAX_BINARY <= 8'b11110010;
		243 : SH_CNT_MAX_BINARY <= 8'b11110011;
		244 : SH_CNT_MAX_BINARY <= 8'b11110100;
		245 : SH_CNT_MAX_BINARY <= 8'b11110101;
		246 : SH_CNT_MAX_BINARY <= 8'b11110110;
		247 : SH_CNT_MAX_BINARY <= 8'b11110111;
		248 : SH_CNT_MAX_BINARY <= 8'b11111000;
		249 : SH_CNT_MAX_BINARY <= 8'b11111001;
		250 : SH_CNT_MAX_BINARY <= 8'b11111010;
		251 : SH_CNT_MAX_BINARY <= 8'b11111011;
		252 : SH_CNT_MAX_BINARY <= 8'b11111100;
		253 : SH_CNT_MAX_BINARY <= 8'b11111101;
		254 : SH_CNT_MAX_BINARY <= 8'b11111110;
		255 : SH_CNT_MAX_BINARY <= 8'b11111111;
		default : begin
			$display("Attribute Syntax Error : The Attribute SH_CNT_MAX on X_GT11 instance %m is set to %d.  Legal values for this attribute are 0 to 255.", SH_CNT_MAX);
			$finish;
		end
	endcase

	case (SH_INVALID_CNT_MAX)
		0 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000000;
		1 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000001;
		2 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000010;
		3 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000011;
		4 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000100;
		5 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000101;
		6 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000110;
		7 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000111;
		8 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001000;
		9 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001001;
		10 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001010;
		11 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001011;
		12 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001100;
		13 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001101;
		14 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001110;
		15 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001111;
		16 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010000;
		17 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010001;
		18 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010010;
		19 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010011;
		20 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010100;
		21 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010101;
		22 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010110;
		23 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010111;
		24 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011000;
		25 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011001;
		26 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011010;
		27 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011011;
		28 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011100;
		29 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011101;
		30 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011110;
		31 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011111;
		32 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100000;
		33 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100001;
		34 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100010;
		35 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100011;
		36 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100100;
		37 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100101;
		38 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100110;
		39 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100111;
		40 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101000;
		41 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101001;
		42 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101010;
		43 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101011;
		44 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101100;
		45 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101101;
		46 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101110;
		47 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101111;
		48 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110000;
		49 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110001;
		50 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110010;
		51 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110011;
		52 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110100;
		53 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110101;
		54 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110110;
		55 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110111;
		56 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111000;
		57 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111001;
		58 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111010;
		59 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111011;
		60 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111100;
		61 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111101;
		62 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111110;
		63 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111111;
		64 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000000;
		65 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000001;
		66 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000010;
		67 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000011;
		68 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000100;
		69 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000101;
		70 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000110;
		71 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000111;
		72 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001000;
		73 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001001;
		74 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001010;
		75 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001011;
		76 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001100;
		77 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001101;
		78 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001110;
		79 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001111;
		80 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010000;
		81 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010001;
		82 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010010;
		83 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010011;
		84 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010100;
		85 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010101;
		86 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010110;
		87 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010111;
		88 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011000;
		89 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011001;
		90 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011010;
		91 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011011;
		92 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011100;
		93 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011101;
		94 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011110;
		95 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011111;
		96 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100000;
		97 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100001;
		98 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100010;
		99 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100011;
		100 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100100;
		101 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100101;
		102 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100110;
		103 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100111;
		104 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101000;
		105 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101001;
		106 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101010;
		107 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101011;
		108 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101100;
		109 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101101;
		110 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101110;
		111 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101111;
		112 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110000;
		113 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110001;
		114 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110010;
		115 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110011;
		116 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110100;
		117 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110101;
		118 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110110;
		119 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110111;
		120 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111000;
		121 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111001;
		122 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111010;
		123 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111011;
		124 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111100;
		125 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111101;
		126 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111110;
		127 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111111;
		128 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000000;
		129 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000001;
		130 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000010;
		131 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000011;
		132 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000100;
		133 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000101;
		134 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000110;
		135 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000111;
		136 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001000;
		137 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001001;
		138 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001010;
		139 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001011;
		140 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001100;
		141 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001101;
		142 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001110;
		143 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001111;
		144 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010000;
		145 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010001;
		146 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010010;
		147 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010011;
		148 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010100;
		149 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010101;
		150 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010110;
		151 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010111;
		152 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011000;
		153 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011001;
		154 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011010;
		155 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011011;
		156 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011100;
		157 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011101;
		158 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011110;
		159 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011111;
		160 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100000;
		161 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100001;
		162 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100010;
		163 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100011;
		164 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100100;
		165 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100101;
		166 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100110;
		167 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100111;
		168 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101000;
		169 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101001;
		170 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101010;
		171 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101011;
		172 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101100;
		173 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101101;
		174 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101110;
		175 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101111;
		176 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110000;
		177 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110001;
		178 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110010;
		179 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110011;
		180 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110100;
		181 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110101;
		182 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110110;
		183 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110111;
		184 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111000;
		185 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111001;
		186 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111010;
		187 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111011;
		188 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111100;
		189 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111101;
		190 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111110;
		191 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111111;
		192 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000000;
		193 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000001;
		194 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000010;
		195 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000011;
		196 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000100;
		197 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000101;
		198 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000110;
		199 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000111;
		200 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001000;
		201 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001001;
		202 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001010;
		203 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001011;
		204 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001100;
		205 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001101;
		206 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001110;
		207 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001111;
		208 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010000;
		209 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010001;
		210 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010010;
		211 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010011;
		212 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010100;
		213 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010101;
		214 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010110;
		215 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010111;
		216 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011000;
		217 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011001;
		218 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011010;
		219 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011011;
		220 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011100;
		221 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011101;
		222 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011110;
		223 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011111;
		224 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100000;
		225 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100001;
		226 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100010;
		227 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100011;
		228 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100100;
		229 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100101;
		230 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100110;
		231 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100111;
		232 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101000;
		233 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101001;
		234 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101010;
		235 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101011;
		236 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101100;
		237 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101101;
		238 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101110;
		239 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101111;
		240 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110000;
		241 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110001;
		242 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110010;
		243 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110011;
		244 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110100;
		245 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110101;
		246 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110110;
		247 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110111;
		248 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111000;
		249 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111001;
		250 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111010;
		251 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111011;
		252 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111100;
		253 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111101;
		254 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111110;
		255 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111111;
		default : begin
			$display("Attribute Syntax Error : The Attribute SH_INVALID_CNT_MAX on X_GT11 instance %m is set to %d.  Legal values for this attribute are 0 to 255.", SH_INVALID_CNT_MAX);
			$finish;
		end
	endcase

	case (ALIGN_COMMA_WORD)
		1 : ALIGN_COMMA_WORD_BINARY <= 2'b00;
		2 : ALIGN_COMMA_WORD_BINARY <= 2'b01;
		4 : ALIGN_COMMA_WORD_BINARY <= 2'b10;
		default : begin
			$display("Attribute Syntax Error : The Attribute ALIGN_COMMA_WORD on X_GT11 instance %m is set to %d.  Legal values for this attribute are 1, 2 or 4.", ALIGN_COMMA_WORD);
			$finish;
		end
	endcase

	case (DEC_MCOMMA_DETECT)
		"FALSE" : DEC_MCOMMA_DETECT_BINARY <= 0;
		"TRUE" : DEC_MCOMMA_DETECT_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DEC_MCOMMA_DETECT on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEC_MCOMMA_DETECT);
			$finish;
		end
	endcase

	case (DEC_PCOMMA_DETECT)
		"FALSE" : DEC_PCOMMA_DETECT_BINARY <= 0;
		"TRUE" : DEC_PCOMMA_DETECT_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DEC_PCOMMA_DETECT on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEC_PCOMMA_DETECT);
			$finish;
		end
	endcase

	case (DEC_VALID_COMMA_ONLY)
		"FALSE" : DEC_VALID_COMMA_ONLY_BINARY <= 0;
		"TRUE" : DEC_VALID_COMMA_ONLY_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DEC_VALID_COMMA_ONLY on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEC_VALID_COMMA_ONLY);
			$finish;
		end
	endcase

	case (MCOMMA_DETECT)
		"FALSE" : MCOMMA_DETECT_BINARY <= 0;
		"TRUE" : MCOMMA_DETECT_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute MCOMMA_DETECT on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", MCOMMA_DETECT);
			$finish;
		end
	endcase

	case (PCOMMA_DETECT)
		"FALSE" : PCOMMA_DETECT_BINARY <= 0;
		"TRUE" : PCOMMA_DETECT_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PCOMMA_DETECT on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PCOMMA_DETECT);
			$finish;
		end
	endcase

	case (COMMA32)
		"FALSE" : COMMA32_BINARY <= 0;
		"TRUE" : COMMA32_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute COMMA32 on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", COMMA32);
			$finish;
		end
	endcase

	case (RXUSRDIVISOR)
		1 : RXUSRDIVISOR_BINARY <= 5'b00001;
		2 : RXUSRDIVISOR_BINARY <= 5'b00010;
		4 : RXUSRDIVISOR_BINARY <= 5'b00100;
		8 : RXUSRDIVISOR_BINARY <= 5'b01000;
		16 : RXUSRDIVISOR_BINARY <= 5'b10000;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXUSRDIVISOR on X_GT11 instance %m is set to %d.  Legal values for this attribute are 1, 2, 4, 8 or 16.", RXUSRDIVISOR);
			$finish;
		end
	endcase

	case (SAMPLE_8X)
		"FALSE" : SAMPLE_8X_BINARY <= 0;
		"TRUE" : SAMPLE_8X_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SAMPLE_8X on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SAMPLE_8X);
			$finish;
		end
	endcase

	case (ENABLE_DCDR)
		"FALSE" : ENABLE_DCDR_BINARY <= 0;
		"TRUE" : ENABLE_DCDR_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute ENABLE_DCDR on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", ENABLE_DCDR);
			$finish;
		end
	endcase

	case (REPEATER)
		"FALSE" : REPEATER_BINARY <= 0;
		"TRUE" : REPEATER_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute REPEATER on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", REPEATER);
			$finish;
		end
	endcase

	case (RXBY_32)
		"FALSE" : RXBY_32_BINARY <= 0;
		"TRUE" : RXBY_32_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXBY_32 on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXBY_32);
			$finish;
		end
	endcase

	case (TXFDCAL_CLOCK_DIVIDE)
		"NONE" : TXFDCAL_CLOCK_DIVIDE_BINARY <= 2'b00;
		"TWO" : TXFDCAL_CLOCK_DIVIDE_BINARY <= 2'b01;
		"FOUR" : TXFDCAL_CLOCK_DIVIDE_BINARY <= 2'b10;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXFDCAL_CLOCK_DIVIDE on X_GT11 instance %m is set to %s.  Legal values for this attribute are NONE, TWO or FOUR.", TXFDCAL_CLOCK_DIVIDE);
			$finish;
		end
	endcase

	case (RXFDCAL_CLOCK_DIVIDE)
		"NONE" : RXFDCAL_CLOCK_DIVIDE_BINARY <= 2'b00;
		"TWO" : RXFDCAL_CLOCK_DIVIDE_BINARY <= 2'b01;
		"FOUR" : RXFDCAL_CLOCK_DIVIDE_BINARY <= 2'b10;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXFDCAL_CLOCK_DIVIDE on X_GT11 instance %m is set to %s.  Legal values for this attribute are NONE, TWO or FOUR.", RXFDCAL_CLOCK_DIVIDE);
			$finish;
		end
	endcase

	case (RXVCO_CTRL_ENABLE)
		"FALSE" : RXVCO_CTRL_ENABLE_BINARY <= 0;
		"TRUE" : RXVCO_CTRL_ENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXVCO_CTRL_ENABLE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXVCO_CTRL_ENABLE);
			$finish;
		end
	endcase

	case (VCO_CTRL_ENABLE)
		"FALSE" : VCO_CTRL_ENABLE_BINARY <= 0;
		"TRUE" : VCO_CTRL_ENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute VCO_CTRL_ENABLE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", VCO_CTRL_ENABLE);
			$finish;
		end
	endcase

	case (RXCRCCLOCKDOUBLE)
		"FALSE" : RXCRCCLOCKDOUBLE_BINARY <= 0;
		"TRUE" : RXCRCCLOCKDOUBLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCRCCLOCKDOUBLE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCRCCLOCKDOUBLE);
			$finish;
		end
	endcase

	case (RXCRCINVERTGEN)
		"FALSE" : RXCRCINVERTGEN_BINARY <= 0;
		"TRUE" : RXCRCINVERTGEN_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCRCINVERTGEN on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCRCINVERTGEN);
			$finish;
		end
	endcase

	case (RXCRCSAMECLOCK)
		"FALSE" : RXCRCSAMECLOCK_BINARY <= 0;
		"TRUE" : RXCRCSAMECLOCK_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCRCSAMECLOCK on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCRCSAMECLOCK);
			$finish;
		end
	endcase

	case (RXCRCENABLE)
		"FALSE" : RXCRCENABLE_BINARY <= 0;
		"TRUE" : RXCRCENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCRCENABLE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCRCENABLE);
			$finish;
		end
	endcase

	case (TXCRCCLOCKDOUBLE)
		"FALSE" : TXCRCCLOCKDOUBLE_BINARY <= 0;
		"TRUE" : TXCRCCLOCKDOUBLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXCRCCLOCKDOUBLE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXCRCCLOCKDOUBLE);
			$finish;
		end
	endcase

	case (TXCRCINVERTGEN)
		"FALSE" : TXCRCINVERTGEN_BINARY <= 0;
		"TRUE" : TXCRCINVERTGEN_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXCRCINVERTGEN on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXCRCINVERTGEN);
			$finish;
		end
	endcase

	case (TXCRCSAMECLOCK)
		"FALSE" : TXCRCSAMECLOCK_BINARY <= 0;
		"TRUE" : TXCRCSAMECLOCK_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXCRCSAMECLOCK on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXCRCSAMECLOCK);
			$finish;
		end
	endcase

	case (TXCRCENABLE)
		"FALSE" : TXCRCENABLE_BINARY <= 0;
		"TRUE" : TXCRCENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXCRCENABLE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXCRCENABLE);
			$finish;
		end
	endcase

	case (RXCLK0_FORCE_PMACLK)
		"FALSE" : RXCLK0_FORCE_PMACLK_BINARY <= 0;
		"TRUE" : RXCLK0_FORCE_PMACLK_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCLK0_FORCE_PMACLK on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCLK0_FORCE_PMACLK);
			$finish;
		end
	endcase

	case (TXCLK0_FORCE_PMACLK)
		"FALSE" : TXCLK0_FORCE_PMACLK_BINARY <= 0;
		"TRUE" : TXCLK0_FORCE_PMACLK_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXCLK0_FORCE_PMACLK on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXCLK0_FORCE_PMACLK);
			$finish;
		end
	endcase

	case (TXOUTCLK1_USE_SYNC)
		"FALSE" : TXOUTCLK1_USE_SYNC_BINARY <= 0;
		"TRUE" : TXOUTCLK1_USE_SYNC_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXOUTCLK1_USE_SYNC on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXOUTCLK1_USE_SYNC);
			$finish;
		end
	endcase

	case (RXRECCLK1_USE_SYNC)
		"FALSE" : RXRECCLK1_USE_SYNC_BINARY <= 0;
		"TRUE" : RXRECCLK1_USE_SYNC_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXRECCLK1_USE_SYNC on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXRECCLK1_USE_SYNC);
			$finish;
		end
	endcase

	case (RXPMACLKSEL)
		"REFCLK1" : RXPMACLKSEL_BINARY <= 2'b00;
		"REFCLK2" : RXPMACLKSEL_BINARY <= 2'b01;
		"GREFCLK" : RXPMACLKSEL_BINARY <= 2'b10;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXPMACLKSEL on X_GT11 instance %m is set to %s.  Legal values for this attribute are REFCLK1, REFCLK2 or GREFCLK.", RXPMACLKSEL);
			$finish;
		end
	endcase

	case (TXABPMACLKSEL)
		"REFCLK1" : TXABPMACLKSEL_BINARY <= 2'b00;
		"REFCLK2" : TXABPMACLKSEL_BINARY <= 2'b01;
		"GREFCLK" : TXABPMACLKSEL_BINARY <= 2'b10;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXABPMACLKSEL on X_GT11 instance %m is set to %s.  Legal values for this attribute are REFCLK1, REFCLK2 or GREFCLK.", TXABPMACLKSEL);
			$finish;
		end
	endcase

	case (BANDGAPSEL)
		"FALSE" : BANDGAPSEL_BINARY <= 0;
		"TRUE" : BANDGAPSEL_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BANDGAPSEL on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BANDGAPSEL);
			$finish;
		end
	endcase

	case (BIASRESSEL)
		"FALSE" : BIASRESSEL_BINARY <= 0;
		"TRUE" : BIASRESSEL_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BIASRESSEL on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BIASRESSEL);
			$finish;
		end
	endcase

	case (TXPHASESEL)
		"FALSE" : TXPHASESEL_BINARY <= 0;
		"TRUE" : TXPHASESEL_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXPHASESEL on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXPHASESEL);
			$finish;
		end
	endcase

	case (PMACLKENABLE)
		"FALSE" : PMACLKENABLE_BINARY <= 0;
		"TRUE" : PMACLKENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMACLKENABLE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PMACLKENABLE);
			$finish;
		end
	endcase

	case (PMACOREPWRENABLE)
		"FALSE" : PMACOREPWRENABLE_BINARY <= 0;
		"TRUE" : PMACOREPWRENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMACOREPWRENABLE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PMACOREPWRENABLE);
			$finish;
		end
	endcase

	case (PMA_BIT_SLIP)
		"FALSE" : PMA_BIT_SLIP_BINARY <= 0;
		"TRUE" : PMA_BIT_SLIP_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMA_BIT_SLIP on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PMA_BIT_SLIP);
			$finish;
		end
	endcase

	case (RXLB)
		"FALSE" : RXLB_BINARY <= 0;
		"TRUE" : RXLB_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXLB on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXLB);
			$finish;
		end
	endcase

	case (RXDCCOUPLE)
		"FALSE" : RXDCCOUPLE_BINARY <= 0;
		"TRUE" : RXDCCOUPLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXDCCOUPLE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXDCCOUPLE);
			$finish;
		end
	endcase

	case (RXDIGRESET)
		"FALSE" : RXDIGRESET_BINARY <= 0;
		"TRUE" : RXDIGRESET_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXDIGRESET on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXDIGRESET);
			$finish;
		end
	endcase

	case (RXCPTST)
		"FALSE" : RXCPTST_BINARY <= 0;
		"TRUE" : RXCPTST_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCPTST on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCPTST);
			$finish;
		end
	endcase

	case (RXPDDTST)
		"FALSE" : RXPDDTST_BINARY <= 0;
		"TRUE" : RXPDDTST_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXPDDTST on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXPDDTST);
			$finish;
		end
	endcase

	case (RXACTST)
		"FALSE" : RXACTST_BINARY <= 0;
		"TRUE" : RXACTST_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXACTST on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXACTST);
			$finish;
		end
	endcase

	case (RXAFETST)
		"FALSE" : RXAFETST_BINARY <= 0;
		"TRUE" : RXAFETST_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXAFETST on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXAFETST);
			$finish;
		end
	endcase

	case (RXLKAPD)
		"FALSE" : RXLKAPD_BINARY <= 0;
		"TRUE" : RXLKAPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXLKAPD on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXLKAPD);
			$finish;
		end
	endcase

	case (RXRSDPD)
		"FALSE" : RXRSDPD_BINARY <= 0;
		"TRUE" : RXRSDPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXRSDPD on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXRSDPD);
			$finish;
		end
	endcase

	case (RXRCPPD)
		"FALSE" : RXRCPPD_BINARY <= 0;
		"TRUE" : RXRCPPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXRCPPD on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXRCPPD);
			$finish;
		end
	endcase

	case (RXRPDPD)
		"FALSE" : RXRPDPD_BINARY <= 0;
		"TRUE" : RXRPDPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXRPDPD on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXRPDPD);
			$finish;
		end
	endcase

	case (RXAFEPD)
		"FALSE" : RXAFEPD_BINARY <= 0;
		"TRUE" : RXAFEPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXAFEPD on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXAFEPD);
			$finish;
		end
	endcase

	case (RXPD)
		"FALSE" : RXPD_BINARY <= 0;
		"TRUE" : RXPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXPD on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXPD);
			$finish;
		end
	endcase

	case (TXOUTDIV2SEL)
		1 : TXOUTDIV2SEL_BINARY <= 4'b0001;
		2 : TXOUTDIV2SEL_BINARY <= 4'b0010;
		4 : TXOUTDIV2SEL_BINARY <= 4'b0011;
		8 : TXOUTDIV2SEL_BINARY <= 4'b0100;
		16 : TXOUTDIV2SEL_BINARY <= 4'b0101;
		32 : TXOUTDIV2SEL_BINARY <= 4'b0110;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXOUTDIV2SEL on X_GT11 instance %m is set to %d.  Legal values for this attribute are 1, 2, 4, 8, 16 or 32.", TXOUTDIV2SEL);
			$finish;
		end
	endcase

	case (TXPLLNDIVSEL)
		8 : TXPLLNDIVSEL_BINARY <= 4'b0000;
		10 : TXPLLNDIVSEL_BINARY <= 4'b0010;
		16 : TXPLLNDIVSEL_BINARY <= 4'b0100;
		20 : TXPLLNDIVSEL_BINARY <= 4'b0110;
		32 : TXPLLNDIVSEL_BINARY <= 4'b1000;
		40 : TXPLLNDIVSEL_BINARY <= 4'b1010;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXPLLNDIVSEL on X_GT11 instance %m is set to %d.  Legal values for this attribute are 8, 10, 16, 20, 32 or 40.", TXPLLNDIVSEL);
			$finish;
		end
	endcase

	case (TXCPSEL)
		"FALSE" : TXCPSEL_BINARY <= 0;
		"TRUE" : TXCPSEL_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXCPSEL on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXCPSEL);
			$finish;
		end
	endcase

	case (TXAPD)
		"FALSE" : TXAPD_BINARY <= 0;
		"TRUE" : TXAPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXAPD on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXAPD);
			$finish;
		end
	endcase

	case (TXLVLSHFTPD)
		"FALSE" : TXLVLSHFTPD_BINARY <= 0;
		"TRUE" : TXLVLSHFTPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXLVLSHFTPD on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXLVLSHFTPD);
			$finish;
		end
	endcase

	case (TXPRE_TAP_PD)
		"FALSE" : TXPRE_TAP_PD_BINARY <= 0;
		"TRUE" : TXPRE_TAP_PD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXPRE_TAP_PD on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXPRE_TAP_PD);
			$finish;
		end
	endcase

	case (TXDIGPD)
		"FALSE" : TXDIGPD_BINARY <= 0;
		"TRUE" : TXDIGPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXDIGPD on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXDIGPD);
			$finish;
		end
	endcase

	case (TXHIGHSIGNALEN)
		"FALSE" : TXHIGHSIGNALEN_BINARY <= 0;
		"TRUE" : TXHIGHSIGNALEN_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXHIGHSIGNALEN on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXHIGHSIGNALEN);
			$finish;
		end
	endcase

	case (TXAREFBIASSEL)
		"FALSE" : TXAREFBIASSEL_BINARY <= 0;
		"TRUE" : TXAREFBIASSEL_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXAREFBIASSEL on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXAREFBIASSEL);
			$finish;
		end
	endcase

	case (TXSLEWRATE)
		"FALSE" : TXSLEWRATE_BINARY <= 0;
		"TRUE" : TXSLEWRATE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXSLEWRATE on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXSLEWRATE);
			$finish;
		end
	endcase

	case (TXPOST_TAP_PD)
		"FALSE" : TXPOST_TAP_PD_BINARY <= 0;
		"TRUE" : TXPOST_TAP_PD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXPOST_TAP_PD on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXPOST_TAP_PD);
			$finish;
		end
	endcase

	case (TXPD)
		"FALSE" : TXPD_BINARY <= 0;
		"TRUE" : TXPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXPD on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXPD);
			$finish;
		end
	endcase

	case (RXOUTDIV2SEL)
		1 : RXOUTDIV2SEL_BINARY <= 8'b00010001;
		2 : RXOUTDIV2SEL_BINARY <= 8'b00100010;
		4 : RXOUTDIV2SEL_BINARY <= 8'b00110011;
		8 : RXOUTDIV2SEL_BINARY <= 8'b01000100;
		16 : RXOUTDIV2SEL_BINARY <= 8'b01010101;
		32 : RXOUTDIV2SEL_BINARY <= 8'b01100110;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXOUTDIV2SEL on X_GT11 instance %m is set to %d.  Legal values for this attribute are 1, 2, 4, 8, 16 or 32.", RXOUTDIV2SEL);
			$finish;
		end
	endcase

	case (RXPLLNDIVSEL)
		8 : RXPLLNDIVSEL_BINARY <= 4'b0000;
		10 : RXPLLNDIVSEL_BINARY <= 4'b0010;
		16 : RXPLLNDIVSEL_BINARY <= 4'b0100;
		20 : RXPLLNDIVSEL_BINARY <= 4'b0110;
		32 : RXPLLNDIVSEL_BINARY <= 4'b1000;
		40 : RXPLLNDIVSEL_BINARY <= 4'b1010;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXPLLNDIVSEL on X_GT11 instance %m is set to %d.  Legal values for this attribute are 8, 10, 16, 20, 32 or 40.", RXPLLNDIVSEL);
			$finish;
		end
	endcase

	case (RXDIGRX)
		"FALSE" : RXDIGRX_BINARY <= 0;
		"TRUE" : RXDIGRX_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXDIGRX on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXDIGRX);
			$finish;
		end
	endcase

	case (RXCPSEL)
		"FALSE" : RXCPSEL_BINARY <= 0;
		"TRUE" : RXCPSEL_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCPSEL on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCPSEL);
			$finish;
		end
	endcase

	case (RXAPD)
		"FALSE" : RXAPD_BINARY <= 0;
		"TRUE" : RXAPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXAPD on X_GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXAPD);
			$finish;
		end
	endcase

end

buf B_CHBONDO0 (CHBONDO[0], CHBONDO_OUT[0]);
buf B_CHBONDO1 (CHBONDO[1], CHBONDO_OUT[1]);
buf B_CHBONDO2 (CHBONDO[2], CHBONDO_OUT[2]);
buf B_CHBONDO3 (CHBONDO[3], CHBONDO_OUT[3]);
buf B_CHBONDO4 (CHBONDO[4], CHBONDO_OUT[4]);
buf B_RXSTATUS0 (RXSTATUS[0], RXSTATUS_OUT[0]);
buf B_RXSTATUS1 (RXSTATUS[1], RXSTATUS_OUT[1]);
buf B_RXSTATUS2 (RXSTATUS[2], RXSTATUS_OUT[2]);
buf B_RXSTATUS3 (RXSTATUS[3], RXSTATUS_OUT[3]);
buf B_RXSTATUS4 (RXSTATUS[4], RXSTATUS_OUT[4]);
buf B_RXSTATUS5 (RXSTATUS[5], RXSTATUS_OUT[5]);
buf B_RXCHARISCOMMA0 (RXCHARISCOMMA[0], RXCHARISCOMMA_OUT[0]);
buf B_RXCHARISCOMMA1 (RXCHARISCOMMA[1], RXCHARISCOMMA_OUT[1]);
buf B_RXCHARISCOMMA2 (RXCHARISCOMMA[2], RXCHARISCOMMA_OUT[2]);
buf B_RXCHARISCOMMA3 (RXCHARISCOMMA[3], RXCHARISCOMMA_OUT[3]);
buf B_RXCHARISCOMMA4 (RXCHARISCOMMA[4], RXCHARISCOMMA_OUT[4]);
buf B_RXCHARISCOMMA5 (RXCHARISCOMMA[5], RXCHARISCOMMA_OUT[5]);
buf B_RXCHARISCOMMA6 (RXCHARISCOMMA[6], RXCHARISCOMMA_OUT[6]);
buf B_RXCHARISCOMMA7 (RXCHARISCOMMA[7], RXCHARISCOMMA_OUT[7]);
buf B_RXCHARISK0 (RXCHARISK[0], RXCHARISK_OUT[0]);
buf B_RXCHARISK1 (RXCHARISK[1], RXCHARISK_OUT[1]);
buf B_RXCHARISK2 (RXCHARISK[2], RXCHARISK_OUT[2]);
buf B_RXCHARISK3 (RXCHARISK[3], RXCHARISK_OUT[3]);
buf B_RXCHARISK4 (RXCHARISK[4], RXCHARISK_OUT[4]);
buf B_RXCHARISK5 (RXCHARISK[5], RXCHARISK_OUT[5]);
buf B_RXCHARISK6 (RXCHARISK[6], RXCHARISK_OUT[6]);
buf B_RXCHARISK7 (RXCHARISK[7], RXCHARISK_OUT[7]);
buf B_RXCOMMADET (RXCOMMADET, RXCOMMADET_OUT);
buf B_RXDATA0 (RXDATA[0], RXDATA_OUT[0]);
buf B_RXDATA1 (RXDATA[1], RXDATA_OUT[1]);
buf B_RXDATA2 (RXDATA[2], RXDATA_OUT[2]);
buf B_RXDATA3 (RXDATA[3], RXDATA_OUT[3]);
buf B_RXDATA4 (RXDATA[4], RXDATA_OUT[4]);
buf B_RXDATA5 (RXDATA[5], RXDATA_OUT[5]);
buf B_RXDATA6 (RXDATA[6], RXDATA_OUT[6]);
buf B_RXDATA7 (RXDATA[7], RXDATA_OUT[7]);
buf B_RXDATA8 (RXDATA[8], RXDATA_OUT[8]);
buf B_RXDATA9 (RXDATA[9], RXDATA_OUT[9]);
buf B_RXDATA10 (RXDATA[10], RXDATA_OUT[10]);
buf B_RXDATA11 (RXDATA[11], RXDATA_OUT[11]);
buf B_RXDATA12 (RXDATA[12], RXDATA_OUT[12]);
buf B_RXDATA13 (RXDATA[13], RXDATA_OUT[13]);
buf B_RXDATA14 (RXDATA[14], RXDATA_OUT[14]);
buf B_RXDATA15 (RXDATA[15], RXDATA_OUT[15]);
buf B_RXDATA16 (RXDATA[16], RXDATA_OUT[16]);
buf B_RXDATA17 (RXDATA[17], RXDATA_OUT[17]);
buf B_RXDATA18 (RXDATA[18], RXDATA_OUT[18]);
buf B_RXDATA19 (RXDATA[19], RXDATA_OUT[19]);
buf B_RXDATA20 (RXDATA[20], RXDATA_OUT[20]);
buf B_RXDATA21 (RXDATA[21], RXDATA_OUT[21]);
buf B_RXDATA22 (RXDATA[22], RXDATA_OUT[22]);
buf B_RXDATA23 (RXDATA[23], RXDATA_OUT[23]);
buf B_RXDATA24 (RXDATA[24], RXDATA_OUT[24]);
buf B_RXDATA25 (RXDATA[25], RXDATA_OUT[25]);
buf B_RXDATA26 (RXDATA[26], RXDATA_OUT[26]);
buf B_RXDATA27 (RXDATA[27], RXDATA_OUT[27]);
buf B_RXDATA28 (RXDATA[28], RXDATA_OUT[28]);
buf B_RXDATA29 (RXDATA[29], RXDATA_OUT[29]);
buf B_RXDATA30 (RXDATA[30], RXDATA_OUT[30]);
buf B_RXDATA31 (RXDATA[31], RXDATA_OUT[31]);
buf B_RXDATA32 (RXDATA[32], RXDATA_OUT[32]);
buf B_RXDATA33 (RXDATA[33], RXDATA_OUT[33]);
buf B_RXDATA34 (RXDATA[34], RXDATA_OUT[34]);
buf B_RXDATA35 (RXDATA[35], RXDATA_OUT[35]);
buf B_RXDATA36 (RXDATA[36], RXDATA_OUT[36]);
buf B_RXDATA37 (RXDATA[37], RXDATA_OUT[37]);
buf B_RXDATA38 (RXDATA[38], RXDATA_OUT[38]);
buf B_RXDATA39 (RXDATA[39], RXDATA_OUT[39]);
buf B_RXDATA40 (RXDATA[40], RXDATA_OUT[40]);
buf B_RXDATA41 (RXDATA[41], RXDATA_OUT[41]);
buf B_RXDATA42 (RXDATA[42], RXDATA_OUT[42]);
buf B_RXDATA43 (RXDATA[43], RXDATA_OUT[43]);
buf B_RXDATA44 (RXDATA[44], RXDATA_OUT[44]);
buf B_RXDATA45 (RXDATA[45], RXDATA_OUT[45]);
buf B_RXDATA46 (RXDATA[46], RXDATA_OUT[46]);
buf B_RXDATA47 (RXDATA[47], RXDATA_OUT[47]);
buf B_RXDATA48 (RXDATA[48], RXDATA_OUT[48]);
buf B_RXDATA49 (RXDATA[49], RXDATA_OUT[49]);
buf B_RXDATA50 (RXDATA[50], RXDATA_OUT[50]);
buf B_RXDATA51 (RXDATA[51], RXDATA_OUT[51]);
buf B_RXDATA52 (RXDATA[52], RXDATA_OUT[52]);
buf B_RXDATA53 (RXDATA[53], RXDATA_OUT[53]);
buf B_RXDATA54 (RXDATA[54], RXDATA_OUT[54]);
buf B_RXDATA55 (RXDATA[55], RXDATA_OUT[55]);
buf B_RXDATA56 (RXDATA[56], RXDATA_OUT[56]);
buf B_RXDATA57 (RXDATA[57], RXDATA_OUT[57]);
buf B_RXDATA58 (RXDATA[58], RXDATA_OUT[58]);
buf B_RXDATA59 (RXDATA[59], RXDATA_OUT[59]);
buf B_RXDATA60 (RXDATA[60], RXDATA_OUT[60]);
buf B_RXDATA61 (RXDATA[61], RXDATA_OUT[61]);
buf B_RXDATA62 (RXDATA[62], RXDATA_OUT[62]);
buf B_RXDATA63 (RXDATA[63], RXDATA_OUT[63]);
buf B_RXDISPERR0 (RXDISPERR[0], RXDISPERR_OUT[0]);
buf B_RXDISPERR1 (RXDISPERR[1], RXDISPERR_OUT[1]);
buf B_RXDISPERR2 (RXDISPERR[2], RXDISPERR_OUT[2]);
buf B_RXDISPERR3 (RXDISPERR[3], RXDISPERR_OUT[3]);
buf B_RXDISPERR4 (RXDISPERR[4], RXDISPERR_OUT[4]);
buf B_RXDISPERR5 (RXDISPERR[5], RXDISPERR_OUT[5]);
buf B_RXDISPERR6 (RXDISPERR[6], RXDISPERR_OUT[6]);
buf B_RXDISPERR7 (RXDISPERR[7], RXDISPERR_OUT[7]);
buf B_RXLOSSOFSYNC0 (RXLOSSOFSYNC[0], RXLOSSOFSYNC_OUT[0]);
buf B_RXLOSSOFSYNC1 (RXLOSSOFSYNC[1], RXLOSSOFSYNC_OUT[1]);
buf B_RXNOTINTABLE0 (RXNOTINTABLE[0], RXNOTINTABLE_OUT[0]);
buf B_RXNOTINTABLE1 (RXNOTINTABLE[1], RXNOTINTABLE_OUT[1]);
buf B_RXNOTINTABLE2 (RXNOTINTABLE[2], RXNOTINTABLE_OUT[2]);
buf B_RXNOTINTABLE3 (RXNOTINTABLE[3], RXNOTINTABLE_OUT[3]);
buf B_RXNOTINTABLE4 (RXNOTINTABLE[4], RXNOTINTABLE_OUT[4]);
buf B_RXNOTINTABLE5 (RXNOTINTABLE[5], RXNOTINTABLE_OUT[5]);
buf B_RXNOTINTABLE6 (RXNOTINTABLE[6], RXNOTINTABLE_OUT[6]);
buf B_RXNOTINTABLE7 (RXNOTINTABLE[7], RXNOTINTABLE_OUT[7]);
buf B_RXREALIGN (RXREALIGN, RXREALIGN_OUT);
buf B_RXRUNDISP0 (RXRUNDISP[0], RXRUNDISP_OUT[0]);
buf B_RXRUNDISP1 (RXRUNDISP[1], RXRUNDISP_OUT[1]);
buf B_RXRUNDISP2 (RXRUNDISP[2], RXRUNDISP_OUT[2]);
buf B_RXRUNDISP3 (RXRUNDISP[3], RXRUNDISP_OUT[3]);
buf B_RXRUNDISP4 (RXRUNDISP[4], RXRUNDISP_OUT[4]);
buf B_RXRUNDISP5 (RXRUNDISP[5], RXRUNDISP_OUT[5]);
buf B_RXRUNDISP6 (RXRUNDISP[6], RXRUNDISP_OUT[6]);
buf B_RXRUNDISP7 (RXRUNDISP[7], RXRUNDISP_OUT[7]);
buf B_RXBUFERR (RXBUFERR, RXBUFERR_OUT);
buf B_TXBUFERR (TXBUFERR, TXBUFERR_OUT);
buf B_TXKERR0 (TXKERR[0], TXKERR_OUT[0]);
buf B_TXKERR1 (TXKERR[1], TXKERR_OUT[1]);
buf B_TXKERR2 (TXKERR[2], TXKERR_OUT[2]);
buf B_TXKERR3 (TXKERR[3], TXKERR_OUT[3]);
buf B_TXKERR4 (TXKERR[4], TXKERR_OUT[4]);
buf B_TXKERR5 (TXKERR[5], TXKERR_OUT[5]);
buf B_TXKERR6 (TXKERR[6], TXKERR_OUT[6]);
buf B_TXKERR7 (TXKERR[7], TXKERR_OUT[7]);
buf B_TXRUNDISP0 (TXRUNDISP[0], TXRUNDISP_OUT[0]);
buf B_TXRUNDISP1 (TXRUNDISP[1], TXRUNDISP_OUT[1]);
buf B_TXRUNDISP2 (TXRUNDISP[2], TXRUNDISP_OUT[2]);
buf B_TXRUNDISP3 (TXRUNDISP[3], TXRUNDISP_OUT[3]);
buf B_TXRUNDISP4 (TXRUNDISP[4], TXRUNDISP_OUT[4]);
buf B_TXRUNDISP5 (TXRUNDISP[5], TXRUNDISP_OUT[5]);
buf B_TXRUNDISP6 (TXRUNDISP[6], TXRUNDISP_OUT[6]);
buf B_TXRUNDISP7 (TXRUNDISP[7], TXRUNDISP_OUT[7]);
buf B_RXRECCLK1 (RXRECCLK1, RXRECCLK1_OUT);
buf B_RXRECCLK2 (RXRECCLK2, RXRECCLK2_OUT);
buf B_TXOUTCLK1 (TXOUTCLK1, TXOUTCLK1_OUT);
buf B_TXOUTCLK2 (TXOUTCLK2, TXOUTCLK2_OUT);
buf B_RXLOCK (RXLOCK, RXLOCK_OUT);
buf B_TXLOCK (TXLOCK, TXLOCK_OUT);
buf B_RXCYCLELIMIT (RXCYCLELIMIT, RXCYCLELIMIT_OUT);
buf B_TXCYCLELIMIT (TXCYCLELIMIT, TXCYCLELIMIT_OUT);
buf B_RXCALFAIL (RXCALFAIL, RXCALFAIL_OUT);
buf B_TXCALFAIL (TXCALFAIL, TXCALFAIL_OUT);
buf B_RXCRCOUT0 (RXCRCOUT[0], RXCRCOUT_OUT[0]);
buf B_RXCRCOUT1 (RXCRCOUT[1], RXCRCOUT_OUT[1]);
buf B_RXCRCOUT2 (RXCRCOUT[2], RXCRCOUT_OUT[2]);
buf B_RXCRCOUT3 (RXCRCOUT[3], RXCRCOUT_OUT[3]);
buf B_RXCRCOUT4 (RXCRCOUT[4], RXCRCOUT_OUT[4]);
buf B_RXCRCOUT5 (RXCRCOUT[5], RXCRCOUT_OUT[5]);
buf B_RXCRCOUT6 (RXCRCOUT[6], RXCRCOUT_OUT[6]);
buf B_RXCRCOUT7 (RXCRCOUT[7], RXCRCOUT_OUT[7]);
buf B_RXCRCOUT8 (RXCRCOUT[8], RXCRCOUT_OUT[8]);
buf B_RXCRCOUT9 (RXCRCOUT[9], RXCRCOUT_OUT[9]);
buf B_RXCRCOUT10 (RXCRCOUT[10], RXCRCOUT_OUT[10]);
buf B_RXCRCOUT11 (RXCRCOUT[11], RXCRCOUT_OUT[11]);
buf B_RXCRCOUT12 (RXCRCOUT[12], RXCRCOUT_OUT[12]);
buf B_RXCRCOUT13 (RXCRCOUT[13], RXCRCOUT_OUT[13]);
buf B_RXCRCOUT14 (RXCRCOUT[14], RXCRCOUT_OUT[14]);
buf B_RXCRCOUT15 (RXCRCOUT[15], RXCRCOUT_OUT[15]);
buf B_RXCRCOUT16 (RXCRCOUT[16], RXCRCOUT_OUT[16]);
buf B_RXCRCOUT17 (RXCRCOUT[17], RXCRCOUT_OUT[17]);
buf B_RXCRCOUT18 (RXCRCOUT[18], RXCRCOUT_OUT[18]);
buf B_RXCRCOUT19 (RXCRCOUT[19], RXCRCOUT_OUT[19]);
buf B_RXCRCOUT20 (RXCRCOUT[20], RXCRCOUT_OUT[20]);
buf B_RXCRCOUT21 (RXCRCOUT[21], RXCRCOUT_OUT[21]);
buf B_RXCRCOUT22 (RXCRCOUT[22], RXCRCOUT_OUT[22]);
buf B_RXCRCOUT23 (RXCRCOUT[23], RXCRCOUT_OUT[23]);
buf B_RXCRCOUT24 (RXCRCOUT[24], RXCRCOUT_OUT[24]);
buf B_RXCRCOUT25 (RXCRCOUT[25], RXCRCOUT_OUT[25]);
buf B_RXCRCOUT26 (RXCRCOUT[26], RXCRCOUT_OUT[26]);
buf B_RXCRCOUT27 (RXCRCOUT[27], RXCRCOUT_OUT[27]);
buf B_RXCRCOUT28 (RXCRCOUT[28], RXCRCOUT_OUT[28]);
buf B_RXCRCOUT29 (RXCRCOUT[29], RXCRCOUT_OUT[29]);
buf B_RXCRCOUT30 (RXCRCOUT[30], RXCRCOUT_OUT[30]);
buf B_RXCRCOUT31 (RXCRCOUT[31], RXCRCOUT_OUT[31]);
buf B_TXCRCOUT0 (TXCRCOUT[0], TXCRCOUT_OUT[0]);
buf B_TXCRCOUT1 (TXCRCOUT[1], TXCRCOUT_OUT[1]);
buf B_TXCRCOUT2 (TXCRCOUT[2], TXCRCOUT_OUT[2]);
buf B_TXCRCOUT3 (TXCRCOUT[3], TXCRCOUT_OUT[3]);
buf B_TXCRCOUT4 (TXCRCOUT[4], TXCRCOUT_OUT[4]);
buf B_TXCRCOUT5 (TXCRCOUT[5], TXCRCOUT_OUT[5]);
buf B_TXCRCOUT6 (TXCRCOUT[6], TXCRCOUT_OUT[6]);
buf B_TXCRCOUT7 (TXCRCOUT[7], TXCRCOUT_OUT[7]);
buf B_TXCRCOUT8 (TXCRCOUT[8], TXCRCOUT_OUT[8]);
buf B_TXCRCOUT9 (TXCRCOUT[9], TXCRCOUT_OUT[9]);
buf B_TXCRCOUT10 (TXCRCOUT[10], TXCRCOUT_OUT[10]);
buf B_TXCRCOUT11 (TXCRCOUT[11], TXCRCOUT_OUT[11]);
buf B_TXCRCOUT12 (TXCRCOUT[12], TXCRCOUT_OUT[12]);
buf B_TXCRCOUT13 (TXCRCOUT[13], TXCRCOUT_OUT[13]);
buf B_TXCRCOUT14 (TXCRCOUT[14], TXCRCOUT_OUT[14]);
buf B_TXCRCOUT15 (TXCRCOUT[15], TXCRCOUT_OUT[15]);
buf B_TXCRCOUT16 (TXCRCOUT[16], TXCRCOUT_OUT[16]);
buf B_TXCRCOUT17 (TXCRCOUT[17], TXCRCOUT_OUT[17]);
buf B_TXCRCOUT18 (TXCRCOUT[18], TXCRCOUT_OUT[18]);
buf B_TXCRCOUT19 (TXCRCOUT[19], TXCRCOUT_OUT[19]);
buf B_TXCRCOUT20 (TXCRCOUT[20], TXCRCOUT_OUT[20]);
buf B_TXCRCOUT21 (TXCRCOUT[21], TXCRCOUT_OUT[21]);
buf B_TXCRCOUT22 (TXCRCOUT[22], TXCRCOUT_OUT[22]);
buf B_TXCRCOUT23 (TXCRCOUT[23], TXCRCOUT_OUT[23]);
buf B_TXCRCOUT24 (TXCRCOUT[24], TXCRCOUT_OUT[24]);
buf B_TXCRCOUT25 (TXCRCOUT[25], TXCRCOUT_OUT[25]);
buf B_TXCRCOUT26 (TXCRCOUT[26], TXCRCOUT_OUT[26]);
buf B_TXCRCOUT27 (TXCRCOUT[27], TXCRCOUT_OUT[27]);
buf B_TXCRCOUT28 (TXCRCOUT[28], TXCRCOUT_OUT[28]);
buf B_TXCRCOUT29 (TXCRCOUT[29], TXCRCOUT_OUT[29]);
buf B_TXCRCOUT30 (TXCRCOUT[30], TXCRCOUT_OUT[30]);
buf B_TXCRCOUT31 (TXCRCOUT[31], TXCRCOUT_OUT[31]);
buf B_RXSIGDET (RXSIGDET, RXSIGDET_OUT);
buf B_DRDY (DRDY, DRDY_OUT);
buf B_DO0 (DO[0], DO_OUT[0]);
buf B_DO1 (DO[1], DO_OUT[1]);
buf B_DO2 (DO[2], DO_OUT[2]);
buf B_DO3 (DO[3], DO_OUT[3]);
buf B_DO4 (DO[4], DO_OUT[4]);
buf B_DO5 (DO[5], DO_OUT[5]);
buf B_DO6 (DO[6], DO_OUT[6]);
buf B_DO7 (DO[7], DO_OUT[7]);
buf B_DO8 (DO[8], DO_OUT[8]);
buf B_DO9 (DO[9], DO_OUT[9]);
buf B_DO10 (DO[10], DO_OUT[10]);
buf B_DO11 (DO[11], DO_OUT[11]);
buf B_DO12 (DO[12], DO_OUT[12]);
buf B_DO13 (DO[13], DO_OUT[13]);
buf B_DO14 (DO[14], DO_OUT[14]);
buf B_DO15 (DO[15], DO_OUT[15]);
buf B_RXMCLK (RXMCLK, RXMCLK_OUT);
buf B_TX1P (TX1P, TX1P_OUT);
buf B_TX1N (TX1N, TX1N_OUT);
buf B_TXPCSHCLKOUT (TXPCSHCLKOUT, TXPCSHCLKOUT_OUT);
buf B_RXPCSHCLKOUT (RXPCSHCLKOUT, RXPCSHCLKOUT_OUT);
buf B_COMBUSOUT0 (COMBUSOUT[0], COMBUSOUT_OUT[0]);
buf B_COMBUSOUT1 (COMBUSOUT[1], COMBUSOUT_OUT[1]);
buf B_COMBUSOUT2 (COMBUSOUT[2], COMBUSOUT_OUT[2]);
buf B_COMBUSOUT3 (COMBUSOUT[3], COMBUSOUT_OUT[3]);
buf B_COMBUSOUT4 (COMBUSOUT[4], COMBUSOUT_OUT[4]);
buf B_COMBUSOUT5 (COMBUSOUT[5], COMBUSOUT_OUT[5]);
buf B_COMBUSOUT6 (COMBUSOUT[6], COMBUSOUT_OUT[6]);
buf B_COMBUSOUT7 (COMBUSOUT[7], COMBUSOUT_OUT[7]);
buf B_COMBUSOUT8 (COMBUSOUT[8], COMBUSOUT_OUT[8]);
buf B_COMBUSOUT9 (COMBUSOUT[9], COMBUSOUT_OUT[9]);
buf B_COMBUSOUT10 (COMBUSOUT[10], COMBUSOUT_OUT[10]);
buf B_COMBUSOUT11 (COMBUSOUT[11], COMBUSOUT_OUT[11]);
buf B_COMBUSOUT12 (COMBUSOUT[12], COMBUSOUT_OUT[12]);
buf B_COMBUSOUT13 (COMBUSOUT[13], COMBUSOUT_OUT[13]);
buf B_COMBUSOUT14 (COMBUSOUT[14], COMBUSOUT_OUT[14]);
buf B_COMBUSOUT15 (COMBUSOUT[15], COMBUSOUT_OUT[15]);

buf B_CHBONDI0 (CHBONDI_IN[0], CHBONDI[0]);
buf B_CHBONDI1 (CHBONDI_IN[1], CHBONDI[1]);
buf B_CHBONDI2 (CHBONDI_IN[2], CHBONDI[2]);
buf B_CHBONDI3 (CHBONDI_IN[3], CHBONDI[3]);
buf B_CHBONDI4 (CHBONDI_IN[4], CHBONDI[4]);
buf B_ENCHANSYNC (ENCHANSYNC_IN, ENCHANSYNC);
buf B_ENMCOMMAALIGN (ENMCOMMAALIGN_IN, ENMCOMMAALIGN);
buf B_ENPCOMMAALIGN (ENPCOMMAALIGN_IN, ENPCOMMAALIGN);
buf B_LOOPBACK0 (LOOPBACK_IN[0], LOOPBACK[0]);
buf B_LOOPBACK1 (LOOPBACK_IN[1], LOOPBACK[1]);
buf B_POWERDOWN (POWERDOWN_IN, POWERDOWN);
buf B_RXBLOCKSYNC64B66BUSE (RXBLOCKSYNC64B66BUSE_IN, RXBLOCKSYNC64B66BUSE);
buf B_RXCOMMADETUSE (RXCOMMADETUSE_IN, RXCOMMADETUSE);
buf B_RXDATAWIDTH0 (RXDATAWIDTH_IN[0], RXDATAWIDTH[0]);
buf B_RXDATAWIDTH1 (RXDATAWIDTH_IN[1], RXDATAWIDTH[1]);
buf B_RXDEC64B66BUSE (RXDEC64B66BUSE_IN, RXDEC64B66BUSE);
buf B_RXDEC8B10BUSE (RXDEC8B10BUSE_IN, RXDEC8B10BUSE);
buf B_RXDESCRAM64B66BUSE (RXDESCRAM64B66BUSE_IN, RXDESCRAM64B66BUSE);
buf B_RXIGNOREBTF (RXIGNOREBTF_IN, RXIGNOREBTF);
buf B_RXINTDATAWIDTH0 (RXINTDATAWIDTH_IN[0], RXINTDATAWIDTH[0]);
buf B_RXINTDATAWIDTH1 (RXINTDATAWIDTH_IN[1], RXINTDATAWIDTH[1]);
buf B_RXPOLARITY (RXPOLARITY_IN, RXPOLARITY);
buf B_RXRESET (RXRESET_IN, RXRESET);
buf B_RXSLIDE (RXSLIDE_IN, RXSLIDE);
buf B_RXUSRCLK (RXUSRCLK_IN, RXUSRCLK);
buf B_RXUSRCLK2 (RXUSRCLK2_IN, RXUSRCLK2);
buf B_TXBYPASS8B10B0 (TXBYPASS8B10B_IN[0], TXBYPASS8B10B[0]);
buf B_TXBYPASS8B10B1 (TXBYPASS8B10B_IN[1], TXBYPASS8B10B[1]);
buf B_TXBYPASS8B10B2 (TXBYPASS8B10B_IN[2], TXBYPASS8B10B[2]);
buf B_TXBYPASS8B10B3 (TXBYPASS8B10B_IN[3], TXBYPASS8B10B[3]);
buf B_TXBYPASS8B10B4 (TXBYPASS8B10B_IN[4], TXBYPASS8B10B[4]);
buf B_TXBYPASS8B10B5 (TXBYPASS8B10B_IN[5], TXBYPASS8B10B[5]);
buf B_TXBYPASS8B10B6 (TXBYPASS8B10B_IN[6], TXBYPASS8B10B[6]);
buf B_TXBYPASS8B10B7 (TXBYPASS8B10B_IN[7], TXBYPASS8B10B[7]);
buf B_TXCHARDISPMODE0 (TXCHARDISPMODE_IN[0], TXCHARDISPMODE[0]);
buf B_TXCHARDISPMODE1 (TXCHARDISPMODE_IN[1], TXCHARDISPMODE[1]);
buf B_TXCHARDISPMODE2 (TXCHARDISPMODE_IN[2], TXCHARDISPMODE[2]);
buf B_TXCHARDISPMODE3 (TXCHARDISPMODE_IN[3], TXCHARDISPMODE[3]);
buf B_TXCHARDISPMODE4 (TXCHARDISPMODE_IN[4], TXCHARDISPMODE[4]);
buf B_TXCHARDISPMODE5 (TXCHARDISPMODE_IN[5], TXCHARDISPMODE[5]);
buf B_TXCHARDISPMODE6 (TXCHARDISPMODE_IN[6], TXCHARDISPMODE[6]);
buf B_TXCHARDISPMODE7 (TXCHARDISPMODE_IN[7], TXCHARDISPMODE[7]);
buf B_TXCHARDISPVAL0 (TXCHARDISPVAL_IN[0], TXCHARDISPVAL[0]);
buf B_TXCHARDISPVAL1 (TXCHARDISPVAL_IN[1], TXCHARDISPVAL[1]);
buf B_TXCHARDISPVAL2 (TXCHARDISPVAL_IN[2], TXCHARDISPVAL[2]);
buf B_TXCHARDISPVAL3 (TXCHARDISPVAL_IN[3], TXCHARDISPVAL[3]);
buf B_TXCHARDISPVAL4 (TXCHARDISPVAL_IN[4], TXCHARDISPVAL[4]);
buf B_TXCHARDISPVAL5 (TXCHARDISPVAL_IN[5], TXCHARDISPVAL[5]);
buf B_TXCHARDISPVAL6 (TXCHARDISPVAL_IN[6], TXCHARDISPVAL[6]);
buf B_TXCHARDISPVAL7 (TXCHARDISPVAL_IN[7], TXCHARDISPVAL[7]);
buf B_TXCHARISK0 (TXCHARISK_IN[0], TXCHARISK[0]);
buf B_TXCHARISK1 (TXCHARISK_IN[1], TXCHARISK[1]);
buf B_TXCHARISK2 (TXCHARISK_IN[2], TXCHARISK[2]);
buf B_TXCHARISK3 (TXCHARISK_IN[3], TXCHARISK[3]);
buf B_TXCHARISK4 (TXCHARISK_IN[4], TXCHARISK[4]);
buf B_TXCHARISK5 (TXCHARISK_IN[5], TXCHARISK[5]);
buf B_TXCHARISK6 (TXCHARISK_IN[6], TXCHARISK[6]);
buf B_TXCHARISK7 (TXCHARISK_IN[7], TXCHARISK[7]);
buf B_TXDATA0 (TXDATA_IN[0], TXDATA[0]);
buf B_TXDATA1 (TXDATA_IN[1], TXDATA[1]);
buf B_TXDATA2 (TXDATA_IN[2], TXDATA[2]);
buf B_TXDATA3 (TXDATA_IN[3], TXDATA[3]);
buf B_TXDATA4 (TXDATA_IN[4], TXDATA[4]);
buf B_TXDATA5 (TXDATA_IN[5], TXDATA[5]);
buf B_TXDATA6 (TXDATA_IN[6], TXDATA[6]);
buf B_TXDATA7 (TXDATA_IN[7], TXDATA[7]);
buf B_TXDATA8 (TXDATA_IN[8], TXDATA[8]);
buf B_TXDATA9 (TXDATA_IN[9], TXDATA[9]);
buf B_TXDATA10 (TXDATA_IN[10], TXDATA[10]);
buf B_TXDATA11 (TXDATA_IN[11], TXDATA[11]);
buf B_TXDATA12 (TXDATA_IN[12], TXDATA[12]);
buf B_TXDATA13 (TXDATA_IN[13], TXDATA[13]);
buf B_TXDATA14 (TXDATA_IN[14], TXDATA[14]);
buf B_TXDATA15 (TXDATA_IN[15], TXDATA[15]);
buf B_TXDATA16 (TXDATA_IN[16], TXDATA[16]);
buf B_TXDATA17 (TXDATA_IN[17], TXDATA[17]);
buf B_TXDATA18 (TXDATA_IN[18], TXDATA[18]);
buf B_TXDATA19 (TXDATA_IN[19], TXDATA[19]);
buf B_TXDATA20 (TXDATA_IN[20], TXDATA[20]);
buf B_TXDATA21 (TXDATA_IN[21], TXDATA[21]);
buf B_TXDATA22 (TXDATA_IN[22], TXDATA[22]);
buf B_TXDATA23 (TXDATA_IN[23], TXDATA[23]);
buf B_TXDATA24 (TXDATA_IN[24], TXDATA[24]);
buf B_TXDATA25 (TXDATA_IN[25], TXDATA[25]);
buf B_TXDATA26 (TXDATA_IN[26], TXDATA[26]);
buf B_TXDATA27 (TXDATA_IN[27], TXDATA[27]);
buf B_TXDATA28 (TXDATA_IN[28], TXDATA[28]);
buf B_TXDATA29 (TXDATA_IN[29], TXDATA[29]);
buf B_TXDATA30 (TXDATA_IN[30], TXDATA[30]);
buf B_TXDATA31 (TXDATA_IN[31], TXDATA[31]);
buf B_TXDATA32 (TXDATA_IN[32], TXDATA[32]);
buf B_TXDATA33 (TXDATA_IN[33], TXDATA[33]);
buf B_TXDATA34 (TXDATA_IN[34], TXDATA[34]);
buf B_TXDATA35 (TXDATA_IN[35], TXDATA[35]);
buf B_TXDATA36 (TXDATA_IN[36], TXDATA[36]);
buf B_TXDATA37 (TXDATA_IN[37], TXDATA[37]);
buf B_TXDATA38 (TXDATA_IN[38], TXDATA[38]);
buf B_TXDATA39 (TXDATA_IN[39], TXDATA[39]);
buf B_TXDATA40 (TXDATA_IN[40], TXDATA[40]);
buf B_TXDATA41 (TXDATA_IN[41], TXDATA[41]);
buf B_TXDATA42 (TXDATA_IN[42], TXDATA[42]);
buf B_TXDATA43 (TXDATA_IN[43], TXDATA[43]);
buf B_TXDATA44 (TXDATA_IN[44], TXDATA[44]);
buf B_TXDATA45 (TXDATA_IN[45], TXDATA[45]);
buf B_TXDATA46 (TXDATA_IN[46], TXDATA[46]);
buf B_TXDATA47 (TXDATA_IN[47], TXDATA[47]);
buf B_TXDATA48 (TXDATA_IN[48], TXDATA[48]);
buf B_TXDATA49 (TXDATA_IN[49], TXDATA[49]);
buf B_TXDATA50 (TXDATA_IN[50], TXDATA[50]);
buf B_TXDATA51 (TXDATA_IN[51], TXDATA[51]);
buf B_TXDATA52 (TXDATA_IN[52], TXDATA[52]);
buf B_TXDATA53 (TXDATA_IN[53], TXDATA[53]);
buf B_TXDATA54 (TXDATA_IN[54], TXDATA[54]);
buf B_TXDATA55 (TXDATA_IN[55], TXDATA[55]);
buf B_TXDATA56 (TXDATA_IN[56], TXDATA[56]);
buf B_TXDATA57 (TXDATA_IN[57], TXDATA[57]);
buf B_TXDATA58 (TXDATA_IN[58], TXDATA[58]);
buf B_TXDATA59 (TXDATA_IN[59], TXDATA[59]);
buf B_TXDATA60 (TXDATA_IN[60], TXDATA[60]);
buf B_TXDATA61 (TXDATA_IN[61], TXDATA[61]);
buf B_TXDATA62 (TXDATA_IN[62], TXDATA[62]);
buf B_TXDATA63 (TXDATA_IN[63], TXDATA[63]);
buf B_TXDATAWIDTH0 (TXDATAWIDTH_IN[0], TXDATAWIDTH[0]);
buf B_TXDATAWIDTH1 (TXDATAWIDTH_IN[1], TXDATAWIDTH[1]);
buf B_TXENC64B66BUSE (TXENC64B66BUSE_IN, TXENC64B66BUSE);
buf B_TXENC8B10BUSE (TXENC8B10BUSE_IN, TXENC8B10BUSE);
buf B_TXGEARBOX64B66BUSE (TXGEARBOX64B66BUSE_IN, TXGEARBOX64B66BUSE);
buf B_TXINHIBIT (TXINHIBIT_IN, TXINHIBIT);
buf B_TXINTDATAWIDTH0 (TXINTDATAWIDTH_IN[0], TXINTDATAWIDTH[0]);
buf B_TXINTDATAWIDTH1 (TXINTDATAWIDTH_IN[1], TXINTDATAWIDTH[1]);
buf B_TXPOLARITY (TXPOLARITY_IN, TXPOLARITY);
buf B_TXRESET (TXRESET_IN, TXRESET);
buf B_TXSCRAM64B66BUSE (TXSCRAM64B66BUSE_IN, TXSCRAM64B66BUSE);
buf B_TXUSRCLK (TXUSRCLK_IN, TXUSRCLK);
buf B_TXUSRCLK2 (TXUSRCLK2_IN, TXUSRCLK2);
buf B_RXCLKSTABLE (RXCLKSTABLE_IN, RXCLKSTABLE);
buf B_RXPMARESET (RXPMARESET_IN, RXPMARESET);
buf B_TXCLKSTABLE (TXCLKSTABLE_IN, TXCLKSTABLE);
buf B_TXPMARESET (TXPMARESET_IN, TXPMARESET);
buf B_RXCRCIN0 (RXCRCIN_IN[0], RXCRCIN[0]);
buf B_RXCRCIN1 (RXCRCIN_IN[1], RXCRCIN[1]);
buf B_RXCRCIN2 (RXCRCIN_IN[2], RXCRCIN[2]);
buf B_RXCRCIN3 (RXCRCIN_IN[3], RXCRCIN[3]);
buf B_RXCRCIN4 (RXCRCIN_IN[4], RXCRCIN[4]);
buf B_RXCRCIN5 (RXCRCIN_IN[5], RXCRCIN[5]);
buf B_RXCRCIN6 (RXCRCIN_IN[6], RXCRCIN[6]);
buf B_RXCRCIN7 (RXCRCIN_IN[7], RXCRCIN[7]);
buf B_RXCRCIN8 (RXCRCIN_IN[8], RXCRCIN[8]);
buf B_RXCRCIN9 (RXCRCIN_IN[9], RXCRCIN[9]);
buf B_RXCRCIN10 (RXCRCIN_IN[10], RXCRCIN[10]);
buf B_RXCRCIN11 (RXCRCIN_IN[11], RXCRCIN[11]);
buf B_RXCRCIN12 (RXCRCIN_IN[12], RXCRCIN[12]);
buf B_RXCRCIN13 (RXCRCIN_IN[13], RXCRCIN[13]);
buf B_RXCRCIN14 (RXCRCIN_IN[14], RXCRCIN[14]);
buf B_RXCRCIN15 (RXCRCIN_IN[15], RXCRCIN[15]);
buf B_RXCRCIN16 (RXCRCIN_IN[16], RXCRCIN[16]);
buf B_RXCRCIN17 (RXCRCIN_IN[17], RXCRCIN[17]);
buf B_RXCRCIN18 (RXCRCIN_IN[18], RXCRCIN[18]);
buf B_RXCRCIN19 (RXCRCIN_IN[19], RXCRCIN[19]);
buf B_RXCRCIN20 (RXCRCIN_IN[20], RXCRCIN[20]);
buf B_RXCRCIN21 (RXCRCIN_IN[21], RXCRCIN[21]);
buf B_RXCRCIN22 (RXCRCIN_IN[22], RXCRCIN[22]);
buf B_RXCRCIN23 (RXCRCIN_IN[23], RXCRCIN[23]);
buf B_RXCRCIN24 (RXCRCIN_IN[24], RXCRCIN[24]);
buf B_RXCRCIN25 (RXCRCIN_IN[25], RXCRCIN[25]);
buf B_RXCRCIN26 (RXCRCIN_IN[26], RXCRCIN[26]);
buf B_RXCRCIN27 (RXCRCIN_IN[27], RXCRCIN[27]);
buf B_RXCRCIN28 (RXCRCIN_IN[28], RXCRCIN[28]);
buf B_RXCRCIN29 (RXCRCIN_IN[29], RXCRCIN[29]);
buf B_RXCRCIN30 (RXCRCIN_IN[30], RXCRCIN[30]);
buf B_RXCRCIN31 (RXCRCIN_IN[31], RXCRCIN[31]);
buf B_RXCRCIN32 (RXCRCIN_IN[32], RXCRCIN[32]);
buf B_RXCRCIN33 (RXCRCIN_IN[33], RXCRCIN[33]);
buf B_RXCRCIN34 (RXCRCIN_IN[34], RXCRCIN[34]);
buf B_RXCRCIN35 (RXCRCIN_IN[35], RXCRCIN[35]);
buf B_RXCRCIN36 (RXCRCIN_IN[36], RXCRCIN[36]);
buf B_RXCRCIN37 (RXCRCIN_IN[37], RXCRCIN[37]);
buf B_RXCRCIN38 (RXCRCIN_IN[38], RXCRCIN[38]);
buf B_RXCRCIN39 (RXCRCIN_IN[39], RXCRCIN[39]);
buf B_RXCRCIN40 (RXCRCIN_IN[40], RXCRCIN[40]);
buf B_RXCRCIN41 (RXCRCIN_IN[41], RXCRCIN[41]);
buf B_RXCRCIN42 (RXCRCIN_IN[42], RXCRCIN[42]);
buf B_RXCRCIN43 (RXCRCIN_IN[43], RXCRCIN[43]);
buf B_RXCRCIN44 (RXCRCIN_IN[44], RXCRCIN[44]);
buf B_RXCRCIN45 (RXCRCIN_IN[45], RXCRCIN[45]);
buf B_RXCRCIN46 (RXCRCIN_IN[46], RXCRCIN[46]);
buf B_RXCRCIN47 (RXCRCIN_IN[47], RXCRCIN[47]);
buf B_RXCRCIN48 (RXCRCIN_IN[48], RXCRCIN[48]);
buf B_RXCRCIN49 (RXCRCIN_IN[49], RXCRCIN[49]);
buf B_RXCRCIN50 (RXCRCIN_IN[50], RXCRCIN[50]);
buf B_RXCRCIN51 (RXCRCIN_IN[51], RXCRCIN[51]);
buf B_RXCRCIN52 (RXCRCIN_IN[52], RXCRCIN[52]);
buf B_RXCRCIN53 (RXCRCIN_IN[53], RXCRCIN[53]);
buf B_RXCRCIN54 (RXCRCIN_IN[54], RXCRCIN[54]);
buf B_RXCRCIN55 (RXCRCIN_IN[55], RXCRCIN[55]);
buf B_RXCRCIN56 (RXCRCIN_IN[56], RXCRCIN[56]);
buf B_RXCRCIN57 (RXCRCIN_IN[57], RXCRCIN[57]);
buf B_RXCRCIN58 (RXCRCIN_IN[58], RXCRCIN[58]);
buf B_RXCRCIN59 (RXCRCIN_IN[59], RXCRCIN[59]);
buf B_RXCRCIN60 (RXCRCIN_IN[60], RXCRCIN[60]);
buf B_RXCRCIN61 (RXCRCIN_IN[61], RXCRCIN[61]);
buf B_RXCRCIN62 (RXCRCIN_IN[62], RXCRCIN[62]);
buf B_RXCRCIN63 (RXCRCIN_IN[63], RXCRCIN[63]);
buf B_RXCRCDATAWIDTH0 (RXCRCDATAWIDTH_IN[0], RXCRCDATAWIDTH[0]);
buf B_RXCRCDATAWIDTH1 (RXCRCDATAWIDTH_IN[1], RXCRCDATAWIDTH[1]);
buf B_RXCRCDATAWIDTH2 (RXCRCDATAWIDTH_IN[2], RXCRCDATAWIDTH[2]);
buf B_RXCRCDATAVALID (RXCRCDATAVALID_IN, RXCRCDATAVALID);
buf B_RXCRCINIT (RXCRCINIT_IN, RXCRCINIT);
buf B_RXCRCRESET (RXCRCRESET_IN, RXCRCRESET);
buf B_RXCRCPD (RXCRCPD_IN, RXCRCPD);
buf B_RXCRCCLK (RXCRCCLK_IN, RXCRCCLK);
buf B_RXCRCINTCLK (RXCRCINTCLK_IN, RXCRCINTCLK);
buf B_TXCRCIN0 (TXCRCIN_IN[0], TXCRCIN[0]);
buf B_TXCRCIN1 (TXCRCIN_IN[1], TXCRCIN[1]);
buf B_TXCRCIN2 (TXCRCIN_IN[2], TXCRCIN[2]);
buf B_TXCRCIN3 (TXCRCIN_IN[3], TXCRCIN[3]);
buf B_TXCRCIN4 (TXCRCIN_IN[4], TXCRCIN[4]);
buf B_TXCRCIN5 (TXCRCIN_IN[5], TXCRCIN[5]);
buf B_TXCRCIN6 (TXCRCIN_IN[6], TXCRCIN[6]);
buf B_TXCRCIN7 (TXCRCIN_IN[7], TXCRCIN[7]);
buf B_TXCRCIN8 (TXCRCIN_IN[8], TXCRCIN[8]);
buf B_TXCRCIN9 (TXCRCIN_IN[9], TXCRCIN[9]);
buf B_TXCRCIN10 (TXCRCIN_IN[10], TXCRCIN[10]);
buf B_TXCRCIN11 (TXCRCIN_IN[11], TXCRCIN[11]);
buf B_TXCRCIN12 (TXCRCIN_IN[12], TXCRCIN[12]);
buf B_TXCRCIN13 (TXCRCIN_IN[13], TXCRCIN[13]);
buf B_TXCRCIN14 (TXCRCIN_IN[14], TXCRCIN[14]);
buf B_TXCRCIN15 (TXCRCIN_IN[15], TXCRCIN[15]);
buf B_TXCRCIN16 (TXCRCIN_IN[16], TXCRCIN[16]);
buf B_TXCRCIN17 (TXCRCIN_IN[17], TXCRCIN[17]);
buf B_TXCRCIN18 (TXCRCIN_IN[18], TXCRCIN[18]);
buf B_TXCRCIN19 (TXCRCIN_IN[19], TXCRCIN[19]);
buf B_TXCRCIN20 (TXCRCIN_IN[20], TXCRCIN[20]);
buf B_TXCRCIN21 (TXCRCIN_IN[21], TXCRCIN[21]);
buf B_TXCRCIN22 (TXCRCIN_IN[22], TXCRCIN[22]);
buf B_TXCRCIN23 (TXCRCIN_IN[23], TXCRCIN[23]);
buf B_TXCRCIN24 (TXCRCIN_IN[24], TXCRCIN[24]);
buf B_TXCRCIN25 (TXCRCIN_IN[25], TXCRCIN[25]);
buf B_TXCRCIN26 (TXCRCIN_IN[26], TXCRCIN[26]);
buf B_TXCRCIN27 (TXCRCIN_IN[27], TXCRCIN[27]);
buf B_TXCRCIN28 (TXCRCIN_IN[28], TXCRCIN[28]);
buf B_TXCRCIN29 (TXCRCIN_IN[29], TXCRCIN[29]);
buf B_TXCRCIN30 (TXCRCIN_IN[30], TXCRCIN[30]);
buf B_TXCRCIN31 (TXCRCIN_IN[31], TXCRCIN[31]);
buf B_TXCRCIN32 (TXCRCIN_IN[32], TXCRCIN[32]);
buf B_TXCRCIN33 (TXCRCIN_IN[33], TXCRCIN[33]);
buf B_TXCRCIN34 (TXCRCIN_IN[34], TXCRCIN[34]);
buf B_TXCRCIN35 (TXCRCIN_IN[35], TXCRCIN[35]);
buf B_TXCRCIN36 (TXCRCIN_IN[36], TXCRCIN[36]);
buf B_TXCRCIN37 (TXCRCIN_IN[37], TXCRCIN[37]);
buf B_TXCRCIN38 (TXCRCIN_IN[38], TXCRCIN[38]);
buf B_TXCRCIN39 (TXCRCIN_IN[39], TXCRCIN[39]);
buf B_TXCRCIN40 (TXCRCIN_IN[40], TXCRCIN[40]);
buf B_TXCRCIN41 (TXCRCIN_IN[41], TXCRCIN[41]);
buf B_TXCRCIN42 (TXCRCIN_IN[42], TXCRCIN[42]);
buf B_TXCRCIN43 (TXCRCIN_IN[43], TXCRCIN[43]);
buf B_TXCRCIN44 (TXCRCIN_IN[44], TXCRCIN[44]);
buf B_TXCRCIN45 (TXCRCIN_IN[45], TXCRCIN[45]);
buf B_TXCRCIN46 (TXCRCIN_IN[46], TXCRCIN[46]);
buf B_TXCRCIN47 (TXCRCIN_IN[47], TXCRCIN[47]);
buf B_TXCRCIN48 (TXCRCIN_IN[48], TXCRCIN[48]);
buf B_TXCRCIN49 (TXCRCIN_IN[49], TXCRCIN[49]);
buf B_TXCRCIN50 (TXCRCIN_IN[50], TXCRCIN[50]);
buf B_TXCRCIN51 (TXCRCIN_IN[51], TXCRCIN[51]);
buf B_TXCRCIN52 (TXCRCIN_IN[52], TXCRCIN[52]);
buf B_TXCRCIN53 (TXCRCIN_IN[53], TXCRCIN[53]);
buf B_TXCRCIN54 (TXCRCIN_IN[54], TXCRCIN[54]);
buf B_TXCRCIN55 (TXCRCIN_IN[55], TXCRCIN[55]);
buf B_TXCRCIN56 (TXCRCIN_IN[56], TXCRCIN[56]);
buf B_TXCRCIN57 (TXCRCIN_IN[57], TXCRCIN[57]);
buf B_TXCRCIN58 (TXCRCIN_IN[58], TXCRCIN[58]);
buf B_TXCRCIN59 (TXCRCIN_IN[59], TXCRCIN[59]);
buf B_TXCRCIN60 (TXCRCIN_IN[60], TXCRCIN[60]);
buf B_TXCRCIN61 (TXCRCIN_IN[61], TXCRCIN[61]);
buf B_TXCRCIN62 (TXCRCIN_IN[62], TXCRCIN[62]);
buf B_TXCRCIN63 (TXCRCIN_IN[63], TXCRCIN[63]);
buf B_TXCRCDATAWIDTH0 (TXCRCDATAWIDTH_IN[0], TXCRCDATAWIDTH[0]);
buf B_TXCRCDATAWIDTH1 (TXCRCDATAWIDTH_IN[1], TXCRCDATAWIDTH[1]);
buf B_TXCRCDATAWIDTH2 (TXCRCDATAWIDTH_IN[2], TXCRCDATAWIDTH[2]);
buf B_TXCRCDATAVALID (TXCRCDATAVALID_IN, TXCRCDATAVALID);
buf B_TXCRCINIT (TXCRCINIT_IN, TXCRCINIT);
buf B_TXCRCRESET (TXCRCRESET_IN, TXCRCRESET);
buf B_TXCRCPD (TXCRCPD_IN, TXCRCPD);
buf B_TXCRCCLK (TXCRCCLK_IN, TXCRCCLK);
buf B_TXCRCINTCLK (TXCRCINTCLK_IN, TXCRCINTCLK);
buf B_TXSYNC (TXSYNC_IN, TXSYNC);
buf B_RXSYNC (RXSYNC_IN, RXSYNC);
buf B_TXENOOB (TXENOOB_IN, TXENOOB);
buf B_DCLK (DCLK_IN, DCLK);
buf B_DADDR0 (DADDR_IN[0], DADDR[0]);
buf B_DADDR1 (DADDR_IN[1], DADDR[1]);
buf B_DADDR2 (DADDR_IN[2], DADDR[2]);
buf B_DADDR3 (DADDR_IN[3], DADDR[3]);
buf B_DADDR4 (DADDR_IN[4], DADDR[4]);
buf B_DADDR5 (DADDR_IN[5], DADDR[5]);
buf B_DADDR6 (DADDR_IN[6], DADDR[6]);
buf B_DADDR7 (DADDR_IN[7], DADDR[7]);
buf B_DEN (DEN_IN, DEN);
buf B_DWE (DWE_IN, DWE);
buf B_DI0 (DI_IN[0], DI[0]);
buf B_DI1 (DI_IN[1], DI[1]);
buf B_DI2 (DI_IN[2], DI[2]);
buf B_DI3 (DI_IN[3], DI[3]);
buf B_DI4 (DI_IN[4], DI[4]);
buf B_DI5 (DI_IN[5], DI[5]);
buf B_DI6 (DI_IN[6], DI[6]);
buf B_DI7 (DI_IN[7], DI[7]);
buf B_DI8 (DI_IN[8], DI[8]);
buf B_DI9 (DI_IN[9], DI[9]);
buf B_DI10 (DI_IN[10], DI[10]);
buf B_DI11 (DI_IN[11], DI[11]);
buf B_DI12 (DI_IN[12], DI[12]);
buf B_DI13 (DI_IN[13], DI[13]);
buf B_DI14 (DI_IN[14], DI[14]);
buf B_DI15 (DI_IN[15], DI[15]);
buf B_RX1P (RX1P_IN, RX1P);
buf B_RX1N (RX1N_IN, RX1N);
buf B_GREFCLK (GREFCLK_IN, GREFCLK);
buf B_REFCLK1 (REFCLK1_IN, REFCLK1);
buf B_REFCLK2 (REFCLK2_IN, REFCLK2);
buf B_COMBUSIN0 (COMBUSIN_IN[0], COMBUSIN[0]);
buf B_COMBUSIN1 (COMBUSIN_IN[1], COMBUSIN[1]);
buf B_COMBUSIN2 (COMBUSIN_IN[2], COMBUSIN[2]);
buf B_COMBUSIN3 (COMBUSIN_IN[3], COMBUSIN[3]);
buf B_COMBUSIN4 (COMBUSIN_IN[4], COMBUSIN[4]);
buf B_COMBUSIN5 (COMBUSIN_IN[5], COMBUSIN[5]);
buf B_COMBUSIN6 (COMBUSIN_IN[6], COMBUSIN[6]);
buf B_COMBUSIN7 (COMBUSIN_IN[7], COMBUSIN[7]);
buf B_COMBUSIN8 (COMBUSIN_IN[8], COMBUSIN[8]);
buf B_COMBUSIN9 (COMBUSIN_IN[9], COMBUSIN[9]);
buf B_COMBUSIN10 (COMBUSIN_IN[10], COMBUSIN[10]);
buf B_COMBUSIN11 (COMBUSIN_IN[11], COMBUSIN[11]);
buf B_COMBUSIN12 (COMBUSIN_IN[12], COMBUSIN[12]);
buf B_COMBUSIN13 (COMBUSIN_IN[13], COMBUSIN[13]);
buf B_COMBUSIN14 (COMBUSIN_IN[14], COMBUSIN[14]);
buf B_COMBUSIN15 (COMBUSIN_IN[15], COMBUSIN[15]);

wire [63:0] synDigCfgChnBnd1;
wire [63:0] synDigCfgChnBnd2;
wire [63:0] synDigCfgClkCor1;
wire [63:0] synDigCfgClkCor2;
wire [63:0] synDigCfgMisc;
wire [63:0] synDigCfgComma1;
wire [63:0] synDigCfgComma2;
wire [63:0] synDigCfgSynPmaFD;
wire [63:0] synDigCfgCrc;
wire [63:0] PMACFG;
wire [63:0] PMACFG2;
wire [63:0] RXAFECFG;
wire [63:0] RXAEQCFG;
wire [63:0] TXCLCFG;
wire [63:0] TXACFG;
wire [63:0] RXACLCFG;

assign synDigCfgChnBnd1 = {
	1'b0, // RESERVED_CB1_BINARY,	// .synDigCfgChnBnd1 63 FALSE
	TX_BUFFER_USE_BINARY,	// .synDigCfgChnBnd1 62 TRUE
	RX_BUFFER_USE_BINARY,	// .synDigCfgChnBnd1 61 TRUE
	CHAN_BOND_SEQ_LEN_BINARY,	// .synDigCfgChnBnd1 60:58 1
	CHAN_BOND_SEQ_2_USE_BINARY,	// .synDigCfgChnBnd1 57 FALSE
	CHAN_BOND_ONE_SHOT_BINARY,	// .synDigCfgChnBnd1 56 FALSE
	CHAN_BOND_MODE_BINARY,	// .synDigCfgChnBnd1 55:54 OFF
	CHAN_BOND_LIMIT_BINARY,	// .synDigCfgChnBnd1 53:48 16
	CHAN_BOND_SEQ_1_MASK,	// .synDigCfgChnBnd1 47:44 4'b0000
	CHAN_BOND_SEQ_1_4,	// .synDigCfgChnBnd1 43:33 11'b00000000000
	CHAN_BOND_SEQ_1_3,	// .synDigCfgChnBnd1 32:22 11'b00000000000
	CHAN_BOND_SEQ_1_2,	// .synDigCfgChnBnd1 21:11 11'b00000000000
	CHAN_BOND_SEQ_1_1	// .synDigCfgChnBnd1 10:0 11'b00000000000
};

assign synDigCfgChnBnd2 = {
	8'b0, // CHAN_BOND_TUNE,	// .synDigCfgChnBnd2 63:56 8'b00000000
	1'b0, //UNUSED BINARY	// .synDigCfgChnBnd2 55 
	1'b0, //UNUSED_BINARY	// .synDigCfgChnBnd2 54
	CCCB_ARBITRATOR_DISABLE_BINARY,	// .synDigCfgChnBnd2 53 FALSE
	OPPOSITE_SELECT_BINARY,	// .synDigCfgChnBnd2 52 FALSE
	POWER_ENABLE_BINARY,	// .synDigCfgChnBnd2 51 TRUE
	3'b0, // TEST_MODE_BINARY,	// .synDigCfgChnBnd2 50:48 3'b000
	CHAN_BOND_SEQ_2_MASK,	// .synDigCfgChnBnd2 47:44 4'b0000
	CHAN_BOND_SEQ_2_4,	// .synDigCfgChnBnd2 43:33 11'b00000000000
	CHAN_BOND_SEQ_2_3,	// .synDigCfgChnBnd2 32:22 11'b00000000000
	CHAN_BOND_SEQ_2_2,	// .synDigCfgChnBnd2 21:11 11'b00000000000
	CHAN_BOND_SEQ_2_1	// .synDigCfgChnBnd2 10:0 11'b00000000000
};

assign synDigCfgClkCor1 = {
	RXDATA_SEL,	// .synDigCfgClkCor1 63:62 2'b00
	TXDATA_SEL,	// .synDigCfgClkCor1 61:60 2'b00
	1'b0, // RESERVED_CCB	// .synDigCfgClkCor1 59 1'b0
	CLK_COR_MIN_LAT_BINARY,	// .synDigCfgClkCor1 58:53 28
	1'b0, // RESERVED_CCA	// .synDigCfgClkCor1 52 1'b0
	PCS_BIT_SLIP_BINARY,	// .synDigCfgClkCor1 51 1'b0
	DIGRX_SYNC_MODE_BINARY, // .synDigCfgClkCor1 50 1'b0
	DIGRX_FWDCLK,	// .synDigCfgClkCor1 49:48 2'b0
	CLK_COR_SEQ_1_MASK,	// .synDigCfgClkCor1 47:44 4'b0000
	CLK_COR_SEQ_1_4,	// .synDigCfgClkCor1 43:33 11'b00000000000
	CLK_COR_SEQ_1_3,	// .synDigCfgClkCor1 32:22 11'b00000000000
	CLK_COR_SEQ_1_2,	// .synDigCfgClkCor1 21:11 11'b00000000000
	CLK_COR_SEQ_1_1	// .synDigCfgClkCor1 10:0 11'b00000000000
};

assign synDigCfgClkCor2 = {
	8'b0, // RX_LOS_THRESHOLD_BINARY,	// .synDigCfgClkCor2 63:56 4
	8'b0, // RX_LOS_INVALID_INCR_BINARY,	// .synDigCfgClkCor2 55:48 1
	CLK_COR_SEQ_2_MASK,	// .synDigCfgClkCor2 47:44 4'b0000
	CLK_COR_SEQ_2_4,	// .synDigCfgClkCor2 43:33 11'b00000000000
	CLK_COR_SEQ_2_3,	// .synDigCfgClkCor2 32:22 11'b00000000000
	CLK_COR_SEQ_2_2,	// .synDigCfgClkCor2 21:11 11'b00000000000
	CLK_COR_SEQ_2_1	// .synDigCfgClkCor2 10:0 11'b00000000000
};

assign synDigCfgMisc = {
	RXRECCLK1_USE_SYNC_BINARY,	// .synDigCfgMisc 63 FALSE
	TXOUTCLK1_USE_SYNC_BINARY,	// .synDigCfgMisc 62 FALSE
	TXCLK0_FORCE_PMACLK_BINARY,	// .synDigCfgMisc 61 1'b0
	RXCLK0_FORCE_PMACLK_BINARY,	// .synDigCfgMisc 60 1'b0
	TX_CLOCK_DIVIDER,	// .synDigCfgMisc 59:58 2'b00
	RX_CLOCK_DIVIDER,	// .synDigCfgMisc 57:56 2'b00
	TXCRCENABLE_BINARY,	// .synDigCfgMisc 55 FALSE
	TXCRCSAMECLOCK_BINARY,	// .synDigCfgMisc 54 FALSE
	TXCRCINVERTGEN_BINARY,	// .synDigCfgMisc 53 FALSE
	TXCRCCLOCKDOUBLE_BINARY,	// .synDigCfgMisc 52 FALSE
	RXCRCENABLE_BINARY,	// .synDigCfgMisc 51 FALSE
	RXCRCSAMECLOCK_BINARY,	// .synDigCfgMisc 50 FALSE
	RXCRCINVERTGEN_BINARY,	// .synDigCfgMisc 49 FALSE
	RXCRCCLOCKDOUBLE_BINARY,	// .synDigCfgMisc 48 FALSE
	RXFDCAL_CLOCK_DIVIDE_BINARY,	// .synDigCfgMisc 47:46 2'b00
	TXFDCAL_CLOCK_DIVIDE_BINARY,	// .synDigCfgMisc 45:44 2'b00
	RXBY_32_BINARY,	// .synDigCfgMisc 43 FALSE
	REPEATER_BINARY,	// .synDigCfgMisc 42 FALSE
	ENABLE_DCDR_BINARY,	// .synDigCfgMisc 41 FALSE
	SAMPLE_8X_BINARY,	// .synDigCfgMisc 40 FALSE
	DCDR_FILTER,	// .synDigCfgMisc 39:37 3'b110
	RXUSRDIVISOR_BINARY,	// .synDigCfgMisc 36:32 1
	SH_INVALID_CNT_MAX_BINARY,	// .synDigCfgMisc 31:24 16
	SH_CNT_MAX_BINARY,	// .synDigCfgMisc 23:16 64
	1'b0, // RESERVED_M2,	// .synDigCfgMisc 15 1'b0
	CLK_COR_8B10B_DE_BINARY,	// .synDigCfgMisc 14 FALSE
	CLK_CORRECT_USE_BINARY,	// .synDigCfgMisc 13 TRUE
	CLK_COR_SEQ_LEN_BINARY,	// .synDigCfgMisc 12:10 1
	CLK_COR_SEQ_DROP_BINARY,	// .synDigCfgMisc 9 FALSE
	CLK_COR_SEQ_2_USE_BINARY,	// .synDigCfgMisc 8 FALSE
	1'b0, // TXCLK0_INVERT_PMALEAF_BINARY,	// .synDigCfgMisc 7 FALSE
	1'b0, // RXCLK0_INVERT_PMALEAF_BINARY_BINARY,	// .synDigCfgMisc 6 FALSE
	CLK_COR_MAX_LAT_BINARY	// .synDigCfgMisc 5:0 36
};

assign synDigCfgComma1 = {
	22'h0, // RESERVED_CM2,	// .synDigCfgComma1 63:42 22'h000000
	COMMA_10B_MASK[9:0],	// .synDigCfgComma1 41:32 10'h007
	24'h0, // RESERVED_CM,	// .synDigCfgComma1 31:8 24'h000000
	COMMA32_BINARY,	// .synDigCfgComma1 7 FALSE
	PCOMMA_DETECT_BINARY,	// .synDigCfgComma1 6 TRUE
	MCOMMA_DETECT_BINARY,	// .synDigCfgComma1 5 TRUE
	DEC_VALID_COMMA_ONLY_BINARY,	// .synDigCfgComma1 4 TRUE
	DEC_PCOMMA_DETECT_BINARY,	// .synDigCfgComma1 3 TRUE
	DEC_MCOMMA_DETECT_BINARY,	// .synDigCfgComma1 2 TRUE
	ALIGN_COMMA_WORD_BINARY	// .synDigCfgComma1 1:0 1
};

assign synDigCfgComma2 = {
	PCOMMA_32B_VALUE,	// .synDigCfgComma2 63:32 PCOMMA_10B_VALUE = 32'Ha1a1a2a2/10'b17c
	MCOMMA_32B_VALUE	// .synDigCfgComma2 31:0 MCOMMA_10B_VALUE = 32'Ha1a1a2a2/10'b283
};

assign synDigCfgSynPmaFD = {
	1'b1, // AUTO_CAL_BINARY,	// .synDigCfgSynPmaFD 63 TRUE
	VCODAC_INIT,	// .synDigCfgSynPmaFD 62:53 10'b1010000000
	2'b00, // SLOWDOWN_CAL, // .synDigCfgSynPmaFD 52:51 2'b00
	1'b0, // BYPASS_FDET_BINARY,	// .synDigCfgSynPmaFD 50 FALSE
	LOOPCAL_WAIT,	// .synDigCfgSynPmaFD 49:48 2'b00
	1'b0, // BYPASS_CAL_BINARY,	// .synDigCfgSynPmaFD 47 FALSE
	FDET_HYS_CAL,	// .synDigCfgSynPmaFD 46:44 3'b000
	FDET_LCK_CAL,	// .synDigCfgSynPmaFD 43:41 3'b000
	FDET_HYS_SEL,	// .synDigCfgSynPmaFD 40:38 3'b000
	FDET_LCK_SEL,	// .synDigCfgSynPmaFD 37:35 3'b000
	VCO_CTRL_ENABLE_BINARY,	// .synDigCfgSynPmaFD 34 FALSE
	CYCLE_LIMIT_SEL,	// .synDigCfgSynPmaFD 33:32 2'b00
	1'b1, // RXAUTO_CAL_BINARY,	// .synDigCfgSynPmaFD 31 TRUE
	RXVCODAC_INIT,	// .synDigCfgSynPmaFD 30:21 10'b1010000000
	RXSLOWDOWN_CAL,	// .synDigCfgSynPmaFD 20:19 2'b00
	1'b0, // RXBYPASS_FDET_BINARY,	// .synDigCfgSynPmaFD 18 FALSE
	RXLOOPCAL_WAIT,	// .synDigCfgSynPmaFD 17:16 2'b00
	1'b0, // RXBYPASS_CAL_BINARY,	// .synDigCfgSynPmaFD 15 FALSE
	RXFDET_HYS_CAL,	// .synDigCfgSynPmaFD 14:12 3'b000
	RXFDET_LCK_CAL,	// .synDigCfgSynPmaFD 11:9 3'b000
	RXFDET_HYS_SEL,	// .synDigCfgSynPmaFD 8:6 3'b000
	RXFDET_LCK_SEL,	// .synDigCfgSynPmaFD 5:3 3'b000
	RXVCO_CTRL_ENABLE_BINARY,	// .synDigCfgSynPmaFD 2 FALSE
	RXCYCLE_LIMIT_SEL	// .synDigCfgSynPmaFD 1:0 2'b00
};

assign synDigCfgCrc = {
	TXCRCINITVAL,	// .synDigCfgCrc 63:32 32'h00000000
	RXCRCINITVAL	// .synDigCfgCrc 31:0 32'h00000000
};

assign PMACFG = {
	2'b0, // UNUSED_BINARY.PMACFG 63:62
	RXPMACLKSEL_BINARY,	// .PMACFG 61:60 2'b00
	RXPMACLKSEL_BINARY, // .PMACFG 59:58
	TXABPMACLKSEL_BINARY,	// .PMACFG 57:56 2'b00
	8'b0, // UNUSED_BINARY,	// .PMACFG 55:48
	1'b0, // PMATUNE_BINARY,	// .PMACFG 47 FALSE
	5'b0, // TXREGCTRL_BINARY,	// .PMACFG 46:42 5'b00000
	5'b0, // RXAREGCTRL_BINARY,	// .PMACFG 41:37 5'b00000
	PMAVBGCTRL,	// .PMACFG 36:32 5'b00000
	BANDGAPSEL_BINARY,	// .PMACFG 31 FALSE
	PMAIREFTRIM,	// .PMACFG 30:27 4'b0000
	IREFBIASMODE,	// .PMACFG 26:25 2'b00
	BIASRESSEL_BINARY,	// .PMACFG 24 FALSE
	PMAVREFTRIM,	// .PMACFG 23:20 =4'b0000
	1'b0, // VREFSELECT_BINARY,	// .PMACFG 19 FALSE
	VREFBIASMODE,	// .PMACFG 18:17 2'b00
	1'b0, // PMABIASPD_BINARY,	// .PMACFG 16 FALSE
	2'b0, // UNUSED_BINARY,	// .PMACFG 15:14
	1'b0, // ATBENABLE_BINARY,	// .PMACFG 13 FALSE
	1'b0, // ATBBUMPEN_BINARY,	// .PMACFG 12 FALSE
	1'b0, // NATBENABLE_BINARY,	// .PMACFG 11 FALSE
	6'b0, // UNUSED_BINARY,	// .PMACFG 10:5
	TXPHASESEL_BINARY,	// .PMACFG 4 FALSE
	1'b0, // UNUSED_BINARY,	// .PMACFG 3 1'0
	1'b0, // PMACTRL_BINARY,	// .PMACFG 2 1'0
	PMACLKENABLE_BINARY,	// .PMACFG 1 TRUE
	PMACOREPWRENABLE_BINARY	// .PMACFG 0 TRUE
};

assign PMACFG2 = {
	46'b0, // UNUSED_BINARY,	// .PMACFG2 63:18
	18'b0 // ATBSEL_BINARY	// .PMACFG2 17:0 18'h00000
};

assign RXAFECFG = {
	6'b0, // RXMODE_BINARY,	// .RXAFECFG 63:58 6'h00
	PMA_BIT_SLIP_BINARY, // 	// .RXAFECFG 57 FALSE
	RXASYNCDIVIDE, // 	// .RXAFECFG 56:55 2'b00
	RXCLKMODE,	// .RXAFECFG 54:49 6'b110000
	RXLB_BINARY,	// .RXAFECFG 48 FALSE
	RXFETUNE,	// .RXAFECFG 47:46 2'b01
	RXRCPADJ,	// .RXAFECFG 45:43 3'b000
	RXRIBADJ,	// .RXAFECFG 42:41 2'b00
	RXAFEEQ,	// .RXAFECFG 40:32 9'h000
	RXCMADJ,	// .RXAFECFG 31:30 2'b00
	RXCDRLOS,	// .RXAFECFG 29:24 6'b000000
	1'b0,	// UNUSED_BINARY, //.RXAFECFG 23 1'b0
	RXDCCOUPLE_BINARY,	// .RXAFECFG 22 FALSE
	1'b0, // UNUSED_BINARY,	// .RXAFECFG 21
	RXLKADJ,	// .RXAFECFG 20:16 5'b00000
	RXDIGRESET_BINARY,	// .RXAFECFG 15 FALSE
	RXFECONTROL2, // .RXAFECFG 14:12
	RXCPTST_BINARY,	// .RXAFECFG 11 FALSE
	RXPDDTST_BINARY,	// .RXAFECFG 10 FALSE
	RXACTST_BINARY,	// .RXAFECFG 9 FALSE
	RXAFETST_BINARY,	// .RXAFECFG 8 FALSE
	RXFECONTROL1,	// .RXAFECFG 7:6
	RXLKAPD_BINARY,	// .RXAFECFG 5 FALSE
	RXRSDPD_BINARY,	// .RXAFECFG 4 FALSE
	RXRCPPD_BINARY,	// .RXAFECFG 3 FALSE
	RXRPDPD_BINARY,	// .RXAFECFG 2 FALSE
	RXAFEPD_BINARY,	// .RXAFECFG 1 FALSE
	RXPD_BINARY	// .RXAFECFG 0 FALSE
};

assign RXAEQCFG = {
	RXEQ	// .RXAEQCFG 63:0 64'h0000000000000000
};

assign TXCLCFG = {
	TXOUTDIV2SEL_BINARY, // .TXCLCFG 63:60
	TXPLLNDIVSEL_BINARY,	// .TXCLCFG 59:56 4'b0000
	2'b0, // TXCLMODE_BINARY,	// .TXCLCFG 55:54 2'b00
	TXLOOPFILT,	// .TXCLCFG 53:50 4'b0000
	1'b0, // UNUSED_BINARY,	// .TXCLCFG 49
	1'b0, // UNUSED_BINARY,	// .TXCLCFG 48
	TXTUNE[12:0], // .TXCLCFG 47:35
	1'b0, // UNUSED_BINARY,	// .TXCLCFG 34
	1'b0, // UNUSED_BINARY,	// .TXCLCFG 33
	TXCPSEL_BINARY,	// .TXCLCFG 32 FALSE
	1'b0, // TXDACTST_BINARY,	// .TXCLCFG 31 FALSE
	TXOUTDIV2SEL_BINARY,	// .TXCLCFG 30:27 4'b0000
	TXCTRL1[9:0], // UNUSED_BINARY,	// .TXCLCFG 26:17
	1'b0, // TXQPPD_BINARY,	// .TXCLCFG 16 FALSE
	1'b0, // TXCMFPD_BINARY,	// .TXCLCFG 15 FALSE
	1'b0, // TXVCOPD_BINARY,	// .TXCLCFG 14 FALSE
	1'b0, // TXADCADJPD_BINARY,	// .TXCLCFG 13 FALSE
	1'b0, // TXDIVPD_BINARY,	// .TXCLCFG 12 FALSE
	1'b0, // TXBIASPD_BINARY,	// .TXCLCFG 11 FALSE
	1'b0, // TXVCOBUFPD_BINARY,	// .TXCLCFG 10 FALSE
	1'b0, // TXDIVBUFPD_BINARY,	// .TXCLCFG 9 FALSE
	TXAPD_BINARY,	// .TXCLCFG 8 FALSE
	1'b0, // TXAPTST_BINARY,	// .TXCLCFG 7 FALSE
	1'b0, // TXCMFTST_BINARY,	// .TXCLCFG 6 FALSE
	1'b0, // TXFILTTST_BINARY,	// .TXCLCFG 5 FALSE
	1'b0, // TXDIVTST_BINARY,	// .TXCLCFG 4 FALSE
	1'b0, // TXPFDTST_BINARY,	// .TXCLCFG 3 FALSE
	1'b0, // TXVCOBUFTST_BINARY,	// .TXCLCFG 2 FALSE
	1'b0, // TXDIVBUFTST_BINARY,	// .TXCLCFG 1 FALSE
	1'b0 // TXVCOTST_BINARY	// .TXCLCFG 0 FALSE
};

assign TXACFG = {
	4'b0, // TXLNDR_TST1_BINARY,	// .TXACFG 63:60 4'b0000
	TXLVLSHFTPD_BINARY,	// .TXACFG 59 FALSE
	TXPRE_PRDRV_DAC,	// .TXACFG 58:56 3'b000
	TXPRE_TAP_PD_BINARY,	// .TXACFG 55 FALSE
	TXPRE_TAP_DAC[4:3],	// .TXACFG 54:53 5'b00000
	TXDIGPD_BINARY,	// .TXACFG 52 FALSE
	TXCLKMODE,	// .TXACFG 51:48 4'b1100
	TXPRE_TAP_DAC[2:0],	// .TXACFG 47:45 5'b00000
	1'b0, // TXCFGENABLE_BINARY,	// .TXACFG 44 FALSE
	TXHIGHSIGNALEN_BINARY,	// .TXACFG 43 TRUE
	TXAREFBIASSEL_BINARY,	// .TXACFG 42 FALSE
	TXTERMTRIM,	// .TXACFG 41:38 4'b0000
	TXASYNCDIVIDE[1], // 	.TXACFG 37 FALSE
	TXSLEWRATE_BINARY,	// .TXACFG 36 FALSE
	TXPOST_PRDRV_DAC,	// .TXACFG 35:33 3'b000
	TXDAT_PRDRV_DAC,	// .TXACFG 32:30 3'b000
	TXASYNCDIVIDE[0], // 	.TXACFG 29 
	TXPOST_TAP_PD_BINARY,	// .TXACFG 28 TRUE
	TXPOST_TAP_DAC,	// .TXACFG 27:23 5'b00000
	2'b0, // TXLNDR_TST2_BINARY,	// .TXACFG 22:21 2'b00
	TXDAT_TAP_DAC,	// .TXACFG 20:16 5'b00000
	15'b0, // UNUSED_BINARY,	// .TXACFG 15:1
	TXPD_BINARY	// .TXACFG 0 FALSE
};

assign RXACLCFG = {
	RXOUTDIV2SEL_BINARY[7:4],	// .RXACLCFG 63:60 4'b0000
	RXPLLNDIVSEL_BINARY,	// .RXACLCFG 59:56 4'b0000
	2'b0, // RXCLMODE_BINARY,	// .RXACLCFG 55:54 2'b00
	RXLOOPFILT,	// .RXACLCFG 53:50 4'b0000
	RXDIGRX_BINARY,	// .RXACLCFG 49 FALSE
	1'b0, // UNUSED_BINARY,	// .RXACLCFG 48 FALSE
	RXTUNE[12:0], // .RXACLCFG 47:35
	1'b0, // UNUSED_BINARY,	// .RXACLCFG 34 FALSE
	1'b0, // UNUSED_BINARY,	// .RXACLCFG 33 FALSE
	RXCPSEL_BINARY,	// .RXACLCFG 32 FALSE
	1'b0, // RXDACTST_BINARY,	// .RXACLCFG 31 FALSE
	RXOUTDIV2SEL_BINARY[3:0], // .RXACLCFG 30:27
	RXCTRL1[9:0], // .RXACLCFG 26:17
	1'b0, // RXQPPD_BINARY,	// .RXACLCFG 16 FALSE
	1'b1, // RXCMFPD_BINARY,	// .RXACLCFG 15 TRUE
	1'b0, // RXVCOPD_BINARY,	// .RXACLCFG 14 FALSE
	1'b0, // RXADCADJPD_BINARY,	// .RXACLCFG 13 FALSE
	1'b0, // RXDIVPD_BINARY,	// .RXACLCFG 12 FALSE
	1'b0, // RXBIASPD_BINARY,	// .RXACLCFG 11 FALSE
	1'b0, // RXVCOBUFPD_BINARY,	// .RXACLCFG 10 FALSE
	1'b0, // RXDIVBUFPD_BINARY,	// .RXACLCFG 9 FALSE
	RXAPD_BINARY,	// .RXACLCFG 8 FALSE
	1'b0, // RXAPTST_BINARY,	// .RXACLCFG 7 FALSE
	1'b0, // RXCMFTST_BINARY,	// .RXACLCFG 6 FALSE
	1'b0, // RXFILTTST_BINARY,	// .RXACLCFG 5 FALSE
	1'b0, // RXDIVTST_BINARY,	// .RXACLCFG 4 FALSE
	1'b0, // RXPFDTST_BINARY,	// .RXACLCFG 3 FALSE
	1'b0, // RXVCOBUFTST_BINARY,	// .RXACLCFG 2 FALSE
	1'b0, // RXDIVBUFTST_BINARY,	// .RXACLCFG 1 FALSE
	1'b0 // RXVCOTST_BINARY	// .RXACLCFG 0 FALSE
};


GT11_SWIFT gt11_swift_1 (
	.GSR (GSR),

	.GT11_MODE(GT11_MODE_BINARY),

	.synDigCfgChnBnd1 (synDigCfgChnBnd1),
	.synDigCfgChnBnd2 (synDigCfgChnBnd2),
	.synDigCfgClkCor1 (synDigCfgClkCor1),
	.synDigCfgClkCor2 (synDigCfgClkCor2),
	.synDigCfgMisc (synDigCfgMisc),
	.synDigCfgComma1 (synDigCfgComma1),
	.synDigCfgComma2 (synDigCfgComma2),
	.synDigCfgSynPmaFD (synDigCfgSynPmaFD),
	.synDigCfgCrc (synDigCfgCrc),
	.PMACFG (PMACFG),
	.PMACFG2 (PMACFG2),
	.RXAFECFG (RXAFECFG),
	.RXAEQCFG (RXAEQCFG),
	.TXCLCFG (TXCLCFG),
	.TXACFG (TXACFG),
	.RXACLCFG (RXACLCFG), 

	.CHBONDO(CHBONDO_OUT),
	.COMBUSOUT(COMBUSOUT_OUT),
	.DO(DO_OUT),
	.DRDY(DRDY_OUT),
	.RXBUFERR(RXBUFERR_OUT),
	.RXCALFAIL(RXCALFAIL_OUT),
	.RXCHARISCOMMA(RXCHARISCOMMA_OUT),
	.RXCHARISK(RXCHARISK_OUT),
	.RXCOMMADET(RXCOMMADET_OUT),
	.RXCRCOUT(RXCRCOUT_OUT),
	.RXCYCLELIMIT(RXCYCLELIMIT_OUT),
	.RXDATA(RXDATA_OUT),
	.RXDISPERR(RXDISPERR_OUT),
	.RXLOCK(RXLOCK_OUT),
	.RXLOSSOFSYNC(RXLOSSOFSYNC_OUT),
	.RXMCLK(RXMCLK_OUT),
	.RXNOTINTABLE(RXNOTINTABLE_OUT),
	.RXPCSHCLKOUT(RXPCSHCLKOUT_OUT),
	.RXREALIGN(RXREALIGN_OUT),
	.RXRECCLK1(RXRECCLK1_OUT),
	.RXRECCLK2(RXRECCLK2_OUT),
	.RXRUNDISP(RXRUNDISP_OUT),
	.RXSIGDET(RXSIGDET_OUT),
	.RXSTATUS(RXSTATUS_OUT),
	.TX1N(TX1N_OUT),
	.TX1P(TX1P_OUT),
	.TXBUFERR(TXBUFERR_OUT),
	.TXCALFAIL(TXCALFAIL_OUT),
	.TXCRCOUT(TXCRCOUT_OUT),
	.TXCYCLELIMIT(TXCYCLELIMIT_OUT),
	.TXKERR(TXKERR_OUT),
	.TXLOCK(TXLOCK_OUT),
	.TXOUTCLK1(TXOUTCLK1_OUT),
	.TXOUTCLK2(TXOUTCLK2_OUT),
	.TXPCSHCLKOUT(TXPCSHCLKOUT_OUT),
	.TXRUNDISP(TXRUNDISP_OUT),

	.CHBONDI(CHBONDI_IN),
	.COMBUSIN(COMBUSIN_IN),
	.DADDR(DADDR_IN),
	.DCLK(DCLK_IN),
	.DEN(DEN_IN),
	.DI(DI_IN),
	.DWE(DWE_IN),
	.ENCHANSYNC(ENCHANSYNC_IN),
	.ENMCOMMAALIGN(ENMCOMMAALIGN_IN),
	.ENPCOMMAALIGN(ENPCOMMAALIGN_IN),
	.GREFCLK(GREFCLK_IN),
	.LOOPBACK(LOOPBACK_IN),
	.POWERDOWN(POWERDOWN_IN),
	.REFCLK1(REFCLK1_IN),
	.REFCLK2(REFCLK2_IN),
	.RX1N(RX1N_IN),
	.RX1P(RX1P_IN),
	.RXBLOCKSYNC64B66BUSE(RXBLOCKSYNC64B66BUSE_IN),
	.RXCLKSTABLE(RXCLKSTABLE_IN),
	.RXCOMMADETUSE(RXCOMMADETUSE_IN),
	.RXCRCCLK(RXCRCCLK_IN),
	.RXCRCDATAVALID(RXCRCDATAVALID_IN),
	.RXCRCDATAWIDTH(RXCRCDATAWIDTH_IN),
	.RXCRCIN(RXCRCIN_IN),
	.RXCRCINIT(RXCRCINIT_IN),
	.RXCRCINTCLK(RXCRCINTCLK_IN),
	.RXCRCPD(RXCRCPD_IN),
	.RXCRCRESET(RXCRCRESET_IN),
	.RXDATAWIDTH(RXDATAWIDTH_IN),
	.RXDEC64B66BUSE(RXDEC64B66BUSE_IN),
	.RXDEC8B10BUSE(RXDEC8B10BUSE_IN),
	.RXDESCRAM64B66BUSE(RXDESCRAM64B66BUSE_IN),
	.RXIGNOREBTF(RXIGNOREBTF_IN),
	.RXINTDATAWIDTH(RXINTDATAWIDTH_IN),
	.RXPMARESET(RXPMARESET_IN),
	.RXPOLARITY(RXPOLARITY_IN),
	.RXRESET(RXRESET_IN),
	.RXSLIDE(RXSLIDE_IN),
	.RXSYNC(RXSYNC_IN),
	.RXUSRCLK(RXUSRCLK_IN),
	.RXUSRCLK2(RXUSRCLK2_IN),
	.TXBYPASS8B10B(TXBYPASS8B10B_IN),
	.TXCHARDISPMODE(TXCHARDISPMODE_IN),
	.TXCHARDISPVAL(TXCHARDISPVAL_IN),
	.TXCHARISK(TXCHARISK_IN),
	.TXCLKSTABLE(TXCLKSTABLE_IN),
	.TXCRCCLK(TXCRCCLK_IN),
	.TXCRCDATAVALID(TXCRCDATAVALID_IN),
	.TXCRCDATAWIDTH(TXCRCDATAWIDTH_IN),
	.TXCRCIN(TXCRCIN_IN),
	.TXCRCINIT(TXCRCINIT_IN),
	.TXCRCINTCLK(TXCRCINTCLK_IN),
	.TXCRCPD(TXCRCPD_IN),
	.TXCRCRESET(TXCRCRESET_IN),
	.TXDATA(TXDATA_IN),
	.TXDATAWIDTH(TXDATAWIDTH_IN),
	.TXENC64B66BUSE(TXENC64B66BUSE_IN),
	.TXENC8B10BUSE(TXENC8B10BUSE_IN),
	.TXENOOB(TXENOOB_IN),
	.TXGEARBOX64B66BUSE(TXGEARBOX64B66BUSE_IN),
	.TXINHIBIT(TXINHIBIT_IN),
	.TXINTDATAWIDTH(TXINTDATAWIDTH_IN),
	.TXPMARESET(TXPMARESET_IN),
	.TXPOLARITY(TXPOLARITY_IN),
	.TXRESET(TXRESET_IN),
	.TXSCRAM64B66BUSE(TXSCRAM64B66BUSE_IN),
	.TXSYNC(TXSYNC_IN),
	.TXUSRCLK(TXUSRCLK_IN),
	.TXUSRCLK2(TXUSRCLK2_IN)
);

specify
	(DCLK => DO[0]) = (100:100:100, 100:100:100);
	(DCLK => DO[10]) = (100:100:100, 100:100:100);
	(DCLK => DO[11]) = (100:100:100, 100:100:100);
	(DCLK => DO[12]) = (100:100:100, 100:100:100);
	(DCLK => DO[13]) = (100:100:100, 100:100:100);
	(DCLK => DO[14]) = (100:100:100, 100:100:100);
	(DCLK => DO[15]) = (100:100:100, 100:100:100);
	(DCLK => DO[1]) = (100:100:100, 100:100:100);
	(DCLK => DO[2]) = (100:100:100, 100:100:100);
	(DCLK => DO[3]) = (100:100:100, 100:100:100);
	(DCLK => DO[4]) = (100:100:100, 100:100:100);
	(DCLK => DO[5]) = (100:100:100, 100:100:100);
	(DCLK => DO[6]) = (100:100:100, 100:100:100);
	(DCLK => DO[7]) = (100:100:100, 100:100:100);
	(DCLK => DO[8]) = (100:100:100, 100:100:100);
	(DCLK => DO[9]) = (100:100:100, 100:100:100);
	(DCLK => DRDY) = (100:100:100, 100:100:100);
//	(GSR => CHBONDO[0]) = (0:0:0, 0:0:0);
//	(GSR => CHBONDO[1]) = (0:0:0, 0:0:0);
//	(GSR => CHBONDO[2]) = (0:0:0, 0:0:0);
//	(GSR => CHBONDO[3]) = (0:0:0, 0:0:0);
//	(GSR => CHBONDO[4]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[0]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[10]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[11]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[12]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[13]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[14]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[15]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[1]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[2]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[3]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[4]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[5]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[6]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[7]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[8]) = (0:0:0, 0:0:0);
//	(GSR => COMBUSOUT[9]) = (0:0:0, 0:0:0);
//	(GSR => DO[0]) = (0:0:0, 0:0:0);
//	(GSR => DO[10]) = (0:0:0, 0:0:0);
//	(GSR => DO[11]) = (0:0:0, 0:0:0);
//	(GSR => DO[12]) = (0:0:0, 0:0:0);
//	(GSR => DO[13]) = (0:0:0, 0:0:0);
//	(GSR => DO[14]) = (0:0:0, 0:0:0);
//	(GSR => DO[15]) = (0:0:0, 0:0:0);
//	(GSR => DO[1]) = (0:0:0, 0:0:0);
//	(GSR => DO[2]) = (0:0:0, 0:0:0);
//	(GSR => DO[3]) = (0:0:0, 0:0:0);
//	(GSR => DO[4]) = (0:0:0, 0:0:0);
//	(GSR => DO[5]) = (0:0:0, 0:0:0);
//	(GSR => DO[6]) = (0:0:0, 0:0:0);
//	(GSR => DO[7]) = (0:0:0, 0:0:0);
//	(GSR => DO[8]) = (0:0:0, 0:0:0);
//	(GSR => DO[9]) = (0:0:0, 0:0:0);
//	(GSR => DRDY) = (0:0:0, 0:0:0);
//	(GSR => RXBUFERR) = (0:0:0, 0:0:0);
//	(GSR => RXCALFAIL) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISCOMMA[0]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISCOMMA[1]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISCOMMA[2]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISCOMMA[3]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISCOMMA[4]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISCOMMA[5]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISCOMMA[6]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISCOMMA[7]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISK[0]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISK[1]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISK[2]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISK[3]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISK[4]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISK[5]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISK[6]) = (0:0:0, 0:0:0);
//	(GSR => RXCHARISK[7]) = (0:0:0, 0:0:0);
//	(GSR => RXCOMMADET) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[0]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[10]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[11]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[12]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[13]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[14]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[15]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[16]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[17]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[18]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[19]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[1]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[20]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[21]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[22]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[23]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[24]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[25]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[26]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[27]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[28]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[29]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[2]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[30]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[31]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[3]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[4]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[5]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[6]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[7]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[8]) = (0:0:0, 0:0:0);
//	(GSR => RXCRCOUT[9]) = (0:0:0, 0:0:0);
//	(GSR => RXCYCLELIMIT) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[0]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[10]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[11]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[12]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[13]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[14]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[15]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[16]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[17]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[18]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[19]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[1]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[20]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[21]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[22]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[23]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[24]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[25]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[26]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[27]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[28]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[29]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[2]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[30]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[31]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[32]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[33]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[34]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[35]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[36]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[37]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[38]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[39]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[3]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[40]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[41]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[42]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[43]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[44]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[45]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[46]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[47]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[48]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[49]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[4]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[50]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[51]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[52]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[53]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[54]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[55]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[56]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[57]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[58]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[59]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[5]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[60]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[61]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[62]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[63]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[6]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[7]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[8]) = (0:0:0, 0:0:0);
//	(GSR => RXDATA[9]) = (0:0:0, 0:0:0);
//	(GSR => RXDISPERR[0]) = (0:0:0, 0:0:0);
//	(GSR => RXDISPERR[1]) = (0:0:0, 0:0:0);
//	(GSR => RXDISPERR[2]) = (0:0:0, 0:0:0);
//	(GSR => RXDISPERR[3]) = (0:0:0, 0:0:0);
//	(GSR => RXDISPERR[4]) = (0:0:0, 0:0:0);
//	(GSR => RXDISPERR[5]) = (0:0:0, 0:0:0);
//	(GSR => RXDISPERR[6]) = (0:0:0, 0:0:0);
//	(GSR => RXDISPERR[7]) = (0:0:0, 0:0:0);
//	(GSR => RXLOCK) = (0:0:0, 0:0:0);
//	(GSR => RXLOSSOFSYNC[0]) = (0:0:0, 0:0:0);
//	(GSR => RXLOSSOFSYNC[1]) = (0:0:0, 0:0:0);
//	(GSR => RXMCLK) = (0:0:0, 0:0:0);
//	(GSR => RXNOTINTABLE[0]) = (0:0:0, 0:0:0);
//	(GSR => RXNOTINTABLE[1]) = (0:0:0, 0:0:0);
//	(GSR => RXNOTINTABLE[2]) = (0:0:0, 0:0:0);
//	(GSR => RXNOTINTABLE[3]) = (0:0:0, 0:0:0);
//	(GSR => RXNOTINTABLE[4]) = (0:0:0, 0:0:0);
//	(GSR => RXNOTINTABLE[5]) = (0:0:0, 0:0:0);
//	(GSR => RXNOTINTABLE[6]) = (0:0:0, 0:0:0);
//	(GSR => RXNOTINTABLE[7]) = (0:0:0, 0:0:0);
//	(GSR => RXPCSHCLKOUT) = (0:0:0, 0:0:0);
//	(GSR => RXREALIGN) = (0:0:0, 0:0:0);
//	(GSR => RXRECCLK1) = (0:0:0, 0:0:0);
//	(GSR => RXRECCLK2) = (0:0:0, 0:0:0);
//	(GSR => RXRUNDISP[0]) = (0:0:0, 0:0:0);
//	(GSR => RXRUNDISP[1]) = (0:0:0, 0:0:0);
//	(GSR => RXRUNDISP[2]) = (0:0:0, 0:0:0);
//	(GSR => RXRUNDISP[3]) = (0:0:0, 0:0:0);
//	(GSR => RXRUNDISP[4]) = (0:0:0, 0:0:0);
//	(GSR => RXRUNDISP[5]) = (0:0:0, 0:0:0);
//	(GSR => RXRUNDISP[6]) = (0:0:0, 0:0:0);
//	(GSR => RXRUNDISP[7]) = (0:0:0, 0:0:0);
//	(GSR => RXSIGDET) = (0:0:0, 0:0:0);
//	(GSR => RXSTATUS[0]) = (0:0:0, 0:0:0);
//	(GSR => RXSTATUS[1]) = (0:0:0, 0:0:0);
//	(GSR => RXSTATUS[2]) = (0:0:0, 0:0:0);
//	(GSR => RXSTATUS[3]) = (0:0:0, 0:0:0);
//	(GSR => RXSTATUS[4]) = (0:0:0, 0:0:0);
//	(GSR => RXSTATUS[5]) = (0:0:0, 0:0:0);
//	(GSR => TX1N) = (0:0:0, 0:0:0);
//	(GSR => TX1P) = (0:0:0, 0:0:0);
//	(GSR => TXBUFERR) = (0:0:0, 0:0:0);
//	(GSR => TXCALFAIL) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[0]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[10]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[11]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[12]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[13]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[14]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[15]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[16]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[17]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[18]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[19]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[1]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[20]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[21]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[22]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[23]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[24]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[25]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[26]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[27]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[28]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[29]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[2]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[30]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[31]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[3]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[4]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[5]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[6]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[7]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[8]) = (0:0:0, 0:0:0);
//	(GSR => TXCRCOUT[9]) = (0:0:0, 0:0:0);
//	(GSR => TXCYCLELIMIT) = (0:0:0, 0:0:0);
//	(GSR => TXKERR[0]) = (0:0:0, 0:0:0);
//	(GSR => TXKERR[1]) = (0:0:0, 0:0:0);
//	(GSR => TXKERR[2]) = (0:0:0, 0:0:0);
//	(GSR => TXKERR[3]) = (0:0:0, 0:0:0);
//	(GSR => TXKERR[4]) = (0:0:0, 0:0:0);
//	(GSR => TXKERR[5]) = (0:0:0, 0:0:0);
//	(GSR => TXKERR[6]) = (0:0:0, 0:0:0);
//	(GSR => TXKERR[7]) = (0:0:0, 0:0:0);
//	(GSR => TXLOCK) = (0:0:0, 0:0:0);
//	(GSR => TXOUTCLK1) = (0:0:0, 0:0:0);
//	(GSR => TXOUTCLK2) = (0:0:0, 0:0:0);
//	(GSR => TXPCSHCLKOUT) = (0:0:0, 0:0:0);
//	(GSR => TXRUNDISP[0]) = (0:0:0, 0:0:0);
//	(GSR => TXRUNDISP[1]) = (0:0:0, 0:0:0);
//	(GSR => TXRUNDISP[2]) = (0:0:0, 0:0:0);
//	(GSR => TXRUNDISP[3]) = (0:0:0, 0:0:0);
//	(GSR => TXRUNDISP[4]) = (0:0:0, 0:0:0);
//	(GSR => TXRUNDISP[5]) = (0:0:0, 0:0:0);
//	(GSR => TXRUNDISP[6]) = (0:0:0, 0:0:0);
//	(GSR => TXRUNDISP[7]) = (0:0:0, 0:0:0);
	(RXCRCINTCLK => RXCRCOUT[0]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[10]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[11]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[12]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[13]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[14]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[15]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[16]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[17]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[18]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[19]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[1]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[20]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[21]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[22]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[23]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[24]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[25]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[26]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[27]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[28]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[29]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[2]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[30]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[31]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[3]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[4]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[5]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[6]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[7]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[8]) = (100:100:100, 100:100:100);
	(RXCRCINTCLK => RXCRCOUT[9]) = (100:100:100, 100:100:100);
	(RXUSRCLK => CHBONDO[0]) = (100:100:100, 100:100:100);
	(RXUSRCLK => CHBONDO[1]) = (100:100:100, 100:100:100);
	(RXUSRCLK => CHBONDO[2]) = (100:100:100, 100:100:100);
	(RXUSRCLK => CHBONDO[3]) = (100:100:100, 100:100:100);
	(RXUSRCLK => CHBONDO[4]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXBUFERR) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISCOMMA[0]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISCOMMA[1]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISCOMMA[2]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISCOMMA[3]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISCOMMA[4]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISCOMMA[5]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISCOMMA[6]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISCOMMA[7]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISK[0]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISK[1]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISK[2]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISK[3]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISK[4]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISK[5]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISK[6]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCHARISK[7]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCOMMADET) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXCYCLELIMIT) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[0]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[10]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[11]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[12]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[13]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[14]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[15]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[16]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[17]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[18]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[19]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[1]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[20]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[21]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[22]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[23]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[24]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[25]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[26]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[27]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[28]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[29]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[2]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[30]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[31]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[32]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[33]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[34]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[35]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[36]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[37]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[38]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[39]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[3]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[40]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[41]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[42]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[43]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[44]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[45]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[46]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[47]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[48]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[49]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[4]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[50]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[51]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[52]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[53]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[54]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[55]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[56]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[57]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[58]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[59]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[5]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[60]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[61]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[62]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[63]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[6]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[7]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[8]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDATA[9]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDISPERR[0]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDISPERR[1]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDISPERR[2]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDISPERR[3]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDISPERR[4]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDISPERR[5]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDISPERR[6]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXDISPERR[7]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXLOCK) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXLOSSOFSYNC[0]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXLOSSOFSYNC[1]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXNOTINTABLE[0]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXNOTINTABLE[1]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXNOTINTABLE[2]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXNOTINTABLE[3]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXNOTINTABLE[4]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXNOTINTABLE[5]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXNOTINTABLE[6]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXNOTINTABLE[7]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXREALIGN) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXRUNDISP[0]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXRUNDISP[1]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXRUNDISP[2]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXRUNDISP[3]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXRUNDISP[4]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXRUNDISP[5]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXRUNDISP[6]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXRUNDISP[7]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXSIGDET) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXSTATUS[0]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXSTATUS[1]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXSTATUS[2]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXSTATUS[3]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXSTATUS[4]) = (100:100:100, 100:100:100);
	(RXUSRCLK2 => RXSTATUS[5]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[0]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[10]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[11]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[12]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[13]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[14]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[15]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[16]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[17]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[18]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[19]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[1]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[20]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[21]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[22]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[23]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[24]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[25]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[26]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[27]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[28]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[29]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[2]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[30]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[31]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[3]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[4]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[5]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[6]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[7]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[8]) = (100:100:100, 100:100:100);
	(TXCRCINTCLK => TXCRCOUT[9]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => RXCALFAIL) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXBUFERR) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXCALFAIL) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXCYCLELIMIT) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXKERR[0]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXKERR[1]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXKERR[2]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXKERR[3]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXKERR[4]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXKERR[5]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXKERR[6]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXKERR[7]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXLOCK) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXRUNDISP[0]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXRUNDISP[1]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXRUNDISP[2]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXRUNDISP[3]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXRUNDISP[4]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXRUNDISP[5]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXRUNDISP[6]) = (100:100:100, 100:100:100);
	(TXUSRCLK2 => TXRUNDISP[7]) = (100:100:100, 100:100:100);
	$period (posedge DCLK, 0:0:0, notifier);
	$period (posedge RXCRCCLK, 0:0:0, notifier);
	$period (posedge RXCRCINTCLK, 0:0:0, notifier);
	$period (posedge RXUSRCLK, 0:0:0, notifier);
	$period (posedge RXUSRCLK2, 0:0:0, notifier);
	$period (posedge TXCRCCLK, 0:0:0, notifier);
	$period (posedge TXCRCINTCLK, 0:0:0, notifier);
	$period (posedge TXUSRCLK, 0:0:0, notifier);
	$period (posedge TXUSRCLK2, 0:0:0, notifier);
	$setuphold (posedge DCLK, negedge DADDR[0], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DADDR[1], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DADDR[2], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DADDR[3], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DADDR[4], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DADDR[5], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DADDR[6], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DADDR[7], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DEN, 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[0], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[10], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[11], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[12], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[13], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[14], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[15], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[1], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[2], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[3], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[4], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[5], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[6], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[7], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[8], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DI[9], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, negedge DWE, 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DADDR[0], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DADDR[1], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DADDR[2], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DADDR[3], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DADDR[4], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DADDR[5], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DADDR[6], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DADDR[7], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DEN, 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[0], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[10], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[11], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[12], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[13], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[14], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[15], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[1], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[2], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[3], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[4], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[5], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[6], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[7], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[8], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DI[9], 0:0:0, 0:0:0);
	$setuphold (posedge DCLK, posedge DWE, 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCDATAVALID, 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCDATAWIDTH[0], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCDATAWIDTH[1], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCDATAWIDTH[2], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCINIT, 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[0], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[10], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[11], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[12], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[13], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[14], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[15], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[16], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[17], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[18], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[19], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[1], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[20], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[21], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[22], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[23], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[24], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[25], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[26], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[27], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[28], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[29], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[2], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[30], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[31], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[32], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[33], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[34], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[35], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[36], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[37], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[38], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[39], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[3], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[40], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[41], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[42], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[43], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[44], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[45], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[46], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[47], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[48], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[49], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[4], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[50], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[51], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[52], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[53], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[54], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[55], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[56], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[57], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[58], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[59], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[5], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[60], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[61], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[62], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[63], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[6], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[7], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[8], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCIN[9], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, negedge RXCRCRESET, 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCDATAVALID, 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCDATAWIDTH[0], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCDATAWIDTH[1], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCDATAWIDTH[2], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCINIT, 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[0], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[10], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[11], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[12], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[13], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[14], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[15], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[16], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[17], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[18], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[19], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[1], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[20], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[21], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[22], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[23], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[24], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[25], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[26], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[27], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[28], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[29], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[2], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[30], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[31], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[32], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[33], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[34], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[35], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[36], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[37], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[38], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[39], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[3], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[40], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[41], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[42], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[43], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[44], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[45], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[46], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[47], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[48], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[49], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[4], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[50], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[51], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[52], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[53], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[54], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[55], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[56], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[57], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[58], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[59], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[5], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[60], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[61], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[62], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[63], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[6], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[7], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[8], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCIN[9], 0:0:0, 0:0:0);
	$setuphold (posedge RXCRCINTCLK, posedge RXCRCRESET, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK, negedge CHBONDI[0], 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK, negedge CHBONDI[1], 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK, negedge CHBONDI[2], 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK, negedge CHBONDI[3], 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK, negedge CHBONDI[4], 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK, posedge CHBONDI[0], 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK, posedge CHBONDI[1], 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK, posedge CHBONDI[2], 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK, posedge CHBONDI[3], 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK, posedge CHBONDI[4], 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, negedge ENCHANSYNC, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, negedge ENMCOMMAALIGN, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, negedge ENPCOMMAALIGN, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, negedge RXCLKSTABLE, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, negedge RXCOMMADETUSE, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, negedge RXIGNOREBTF, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, negedge RXPMARESET, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, negedge RXRESET, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, negedge RXSLIDE, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, negedge RXSYNC, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, posedge ENCHANSYNC, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, posedge ENMCOMMAALIGN, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, posedge ENPCOMMAALIGN, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, posedge RXCLKSTABLE, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, posedge RXCOMMADETUSE, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, posedge RXIGNOREBTF, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, posedge RXPMARESET, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, posedge RXRESET, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, posedge RXSLIDE, 0:0:0, 0:0:0);
	$setuphold (posedge RXUSRCLK2, posedge RXSYNC, 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCDATAVALID, 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCDATAWIDTH[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCDATAWIDTH[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCDATAWIDTH[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCINIT, 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[10], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[11], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[12], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[13], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[14], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[15], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[16], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[17], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[18], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[19], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[20], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[21], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[22], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[23], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[24], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[25], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[26], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[27], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[28], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[29], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[30], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[31], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[32], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[33], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[34], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[35], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[36], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[37], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[38], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[39], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[3], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[40], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[41], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[42], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[43], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[44], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[45], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[46], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[47], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[48], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[49], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[4], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[50], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[51], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[52], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[53], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[54], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[55], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[56], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[57], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[58], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[59], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[5], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[60], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[61], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[62], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[63], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[6], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[7], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[8], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCIN[9], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, negedge TXCRCRESET, 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCDATAVALID, 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCDATAWIDTH[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCDATAWIDTH[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCDATAWIDTH[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCINIT, 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[10], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[11], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[12], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[13], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[14], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[15], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[16], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[17], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[18], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[19], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[20], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[21], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[22], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[23], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[24], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[25], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[26], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[27], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[28], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[29], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[30], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[31], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[32], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[33], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[34], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[35], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[36], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[37], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[38], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[39], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[3], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[40], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[41], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[42], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[43], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[44], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[45], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[46], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[47], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[48], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[49], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[4], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[50], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[51], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[52], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[53], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[54], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[55], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[56], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[57], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[58], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[59], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[5], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[60], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[61], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[62], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[63], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[6], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[7], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[8], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCIN[9], 0:0:0, 0:0:0);
	$setuphold (posedge TXCRCINTCLK, posedge TXCRCRESET, 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXBYPASS8B10B[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXBYPASS8B10B[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXBYPASS8B10B[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXBYPASS8B10B[3], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXBYPASS8B10B[4], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXBYPASS8B10B[5], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXBYPASS8B10B[6], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXBYPASS8B10B[7], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPMODE[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPMODE[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPMODE[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPMODE[3], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPMODE[4], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPMODE[5], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPMODE[6], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPMODE[7], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPVAL[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPVAL[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPVAL[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPVAL[3], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPVAL[4], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPVAL[5], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPVAL[6], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARDISPVAL[7], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARISK[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARISK[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARISK[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARISK[3], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARISK[4], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARISK[5], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARISK[6], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCHARISK[7], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXCLKSTABLE, 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[10], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[11], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[12], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[13], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[14], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[15], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[16], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[17], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[18], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[19], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[20], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[21], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[22], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[23], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[24], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[25], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[26], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[27], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[28], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[29], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[30], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[31], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[32], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[33], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[34], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[35], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[36], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[37], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[38], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[39], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[3], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[40], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[41], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[42], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[43], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[44], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[45], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[46], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[47], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[48], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[49], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[4], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[50], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[51], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[52], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[53], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[54], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[55], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[56], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[57], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[58], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[59], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[5], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[60], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[61], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[62], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[63], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[6], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[7], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[8], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXDATA[9], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXENOOB, 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXPMARESET, 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXRESET, 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, negedge TXSYNC, 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXBYPASS8B10B[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXBYPASS8B10B[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXBYPASS8B10B[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXBYPASS8B10B[3], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXBYPASS8B10B[4], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXBYPASS8B10B[5], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXBYPASS8B10B[6], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXBYPASS8B10B[7], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPMODE[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPMODE[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPMODE[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPMODE[3], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPMODE[4], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPMODE[5], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPMODE[6], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPMODE[7], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPVAL[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPVAL[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPVAL[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPVAL[3], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPVAL[4], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPVAL[5], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPVAL[6], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARDISPVAL[7], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARISK[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARISK[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARISK[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARISK[3], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARISK[4], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARISK[5], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARISK[6], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCHARISK[7], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXCLKSTABLE, 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[0], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[10], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[11], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[12], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[13], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[14], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[15], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[16], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[17], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[18], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[19], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[1], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[20], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[21], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[22], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[23], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[24], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[25], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[26], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[27], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[28], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[29], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[2], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[30], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[31], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[32], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[33], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[34], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[35], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[36], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[37], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[38], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[39], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[3], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[40], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[41], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[42], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[43], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[44], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[45], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[46], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[47], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[48], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[49], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[4], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[50], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[51], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[52], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[53], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[54], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[55], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[56], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[57], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[58], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[59], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[5], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[60], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[61], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[62], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[63], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[6], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[7], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[8], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXDATA[9], 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXENOOB, 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXPMARESET, 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXRESET, 0:0:0, 0:0:0);
	$setuphold (posedge TXUSRCLK2, posedge TXSYNC, 0:0:0, 0:0:0);
	specparam PATHPULSE$ = 0;
endspecify
endmodule
